; need to get bakeout heater controller status

pro eis_sts1_reformatter::unpack_icu_counter_parameters, packet_data_array, p0, p1, p2, p3 ,p4, p5
  self->trace, 'eis_sts1_reformatter::unpack_icu_counter_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  p0 = float(packet_data_array[*].mdp_time)
  p1 = float(packet_data_array[*].status_pc)
  p2 = float(packet_data_array[*].tc_rec)
  p3 = float(packet_data_array[*].seq_abort_code and 'FFF0'X)
  p4 = float(packet_data_array[*].seq_run_rem)
  p5 = float(packet_data_array[*].exp_no)

end

pro eis_sts1_reformatter::create_icu_counter_parameters_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts1_reformatter::create_icu_counter_parameters_bintable_extension'

  self->unpack_icu_counter_parameters, packet_data_array, p0, p1, p2, p3 ,p4, p5

  if self.padding then begin
     self->pad, p0, pntrs
     self->pad, p1, pntrs
     self->pad, p2, pntrs
     self->pad, p3, pntrs
     self->pad, p4, pntrs
     self->pad, p5, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0, 'MDP_TIME',       'MDP Time',                   tunit='None', tdmin=min(p0), tdmax=max(p0)
  fxbaddcol, col, header, p1, 'STATUS_PC',      'Status packet counter',      tunit='None', tdmin=min(p1), tdmax=max(p1)
  fxbaddcol, col, header, p2, 'TC_REC_PKTC',    'Tc received counter',        tunit='None', tdmin=min(p2), tdmax=max(p2)
  fxbaddcol, col, header, p3, 'RASTER_RUN_REM', 'Rasters remaining to run',   tunit='None', tdmin=min(p3), tdmax=max(p3)
  fxbaddcol, col, header, p4, 'SEQ_RUN_REM',    'Sequences remaining to run', tunit='None', tdmin=min(p4), tdmax=max(p4)
  fxbaddcol, col, header, p5, 'EXP_NUM',        'Exposure counter',           tunit='None', tdmin=min(p5), tdmax=max(p5)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0, 1, 1, 'MDP_TIME'
  self->write_data, lu, p1, 2, 1, 'STATUS_PC'
  self->write_data, lu, p2, 3, 1, 'TC_REC_PKTC'
  self->write_data, lu, p3, 4, 1, 'RASTER_RUN_REM'
  self->write_data, lu, p4, 5, 1, 'SEQ_RUN_REM'
  self->write_data, lu, p5, 6, 1, 'EXP_NUM'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
