pro eis_sts1_reformatter::unpack_icu_error_parameters, packet_data_array, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20
  self->trace, 'eis_sts1_reformatter::unpack_icu_error_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  p0  = float(ishft(packet_data_array[*].mode, -4)) ; bits 4 - 7 (bit 0 is most significant)
  p1  = float(packet_data_array[*].cmd_if_err)
  p2  = float(ishft((packet_data_array[*].ccd_buf and '30'X), -4)) ; and some bits and shift right some bits
  p3  = float(packet_data_array[*].tc_fail_id)
  p4  = float(packet_data_array[*].icu_errf)
  p5  = float(packet_data_array[*].xrt_err)
  p6  = float((packet_data_array[*].asrc_stat and '40'X) eq '40'X)
  p7  = float((packet_data_array[*].asrc_stat and '80'X) eq '80'X)
  p8  = float(packet_data_array[*].ll_err)
  p9  = float(packet_data_array[*].mhc_cmd_h)
  
  p10 = float(ishft((packet_data_array[*].xrt_ff_stat and '0C'X), -2))
  p11 = float(ishft((packet_data_array[*].ee_pcopy and '04'X), -2))
  p12 = float(ishft((packet_data_array[*].ee_pcopy and '08'X), -3))
  p13 = float(ishft((packet_data_array[*].ee_pcopy and '10'X), -4))
  
  p14 = float(packet_data_array[*].cam_if_error)
  p15 = float(packet_data_array[*].seq_abort_code and 'F'X)
  p16 = float(packet_data_array[*].cmd_id_failed_int)
  p17 = float(packet_data_array[*].mhc_if_err and '3FFF'X)
  p18 = float(ishft((packet_data_array[*].mhc_if_err and 'C000'X), -14))
  p19 = float(packet_data_array[*].et_err)
  p20 = float(packet_data_array[*].tc_fail_pktc)
end

pro eis_sts1_reformatter::create_icu_error_parameters_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts1_reformatter::create_icu_error_parameters_bintable_extension'
;return
  self->unpack_icu_error_parameters, packet_data_array, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20

  if self.padding then begin
     self->pad, p0,  pntrs
     self->pad, p1,  pntrs
     self->pad, p2,  pntrs
     self->pad, p3,  pntrs
     self->pad, p4,  pntrs
     self->pad, p5,  pntrs
     self->pad, p6,  pntrs
     self->pad, p7,  pntrs
     self->pad, p8,  pntrs
     self->pad, p9,  pntrs
     self->pad, p10, pntrs
     self->pad, p11, pntrs
     self->pad, p12, pntrs
     self->pad, p13, pntrs
     self->pad, p14, pntrs
     self->pad, p15, pntrs
     self->pad, p16, pntrs
     self->pad, p17, pntrs
     self->pad, p18, pntrs
     self->pad, p19, pntrs
     self->pad, p20, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0,  'TC_FAILED_EC',      'Failed Telecommand Error Code',             tunit='None', tdmin=min(p0),  tdmax=max(p0)
  fxbaddcol, col, header, p1,  'CMD_IF_ERROR',      'Telecommand Interface Error',               tunit='None', tdmin=min(p1),  tdmax=max(p1)
  fxbaddcol, col, header, p2,  'PSU_STAT_ERROR',    'PSU Status Error',                          tunit='None', tdmin=min(p2),  tdmax=max(p2)
  fxbaddcol, col, header, p3,  'TC_FAILED_CMD_ID',  'Command Id of Failed Telecommand',          tunit='None', tdmin=min(p3),  tdmax=max(p3)
  fxbaddcol, col, header, p4,  'ICU_ERROR_F',       'ICU Error Flag',                            tunit='None', tdmin=min(p4),  tdmax=max(p4)
  fxbaddcol, col, header, p5,  'XRT_ERROR',         'Xrt Response Error',                        tunit='None', tdmin=min(p5),  tdmax=max(p5)
  fxbaddcol, col, header, p6,  'HC_DUTY_ERROR',     'Bakeout Heater Duty Cycle Error',           tunit='None', tdmin=min(p6),  tdmax=max(p6)
  fxbaddcol, col, header, p7,  'HC_PSU_TO',         'Bakeout Heater to PSU Communication Error', tunit='None', tdmin=min(p7),  tdmax=max(p7)
  fxbaddcol, col, header, p8,  'MDP_LL_ERROR',      'MDP Data Line List Error',                  tunit='None', tdmin=min(p8),  tdmax=max(p8)
  fxbaddcol, col, header, p9,  'MHC_CMD_H',         'Rejected MHC Command Header',               tunit='None', tdmin=min(p9),  tdmax=max(p9)
  fxbaddcol, col, header, p10, 'FT_ERROR',          'Eis Flare Trigger Response Error',          tunit='None', tdmin=min(p10), tdmax=max(p10)
  fxbaddcol, col, header, p11, 'AEC_WIN_ERROR',     'No Line Marker In Line List',               tunit='None', tdmin=min(p11), tdmax=max(p11)
  fxbaddcol, col, header, p12, 'AEC_PARMS_ERROR',   'Error In AEC Parameter Table',              tunit='None', tdmin=min(p12), tdmax=max(p12)
  fxbaddcol, col, header, p13, 'AEC_TIME_ERROR',    'AEC Timetable Error Detected',              tunit='None', tdmin=min(p13), tdmax=max(p13)

;  fxbaddcol, col, header, p14, 'CAM_IF_ERROR',      'ICU-PSU Communication Error',               tunit='None', tdmin=min(p14), tdmax=max(p14)
  fxbaddcol, col, header, p14, 'CAM_IF_ERROR',      'ICU-CAM Communication Error',               tunit='None', tdmin=min(p14), tdmax=max(p14)

  fxbaddcol, col, header, p15, 'SEQ_ABORT_CODE',    'Science Sequence Abort Code',               tunit='None', tdmin=min(p15), tdmax=max(p15)
  fxbaddcol, col, header, p16, 'CMD_ID_FAILED_INT', 'Internal Command Rejected By The ICU',      tunit='None', tdmin=min(p16), tdmax=max(p16)
  fxbaddcol, col, header, p17, 'MHC_IF_ERROR',      'ICU-MHC Communication Error',               tunit='None', tdmin=min(p17), tdmax=max(p17)
  fxbaddcol, col, header, p18, 'EEPROM_ERROR',      'Eeprom Communication Error',                tunit='None', tdmin=min(p18), tdmax=max(p18)
  fxbaddcol, col, header, p19, 'ET_ERROR',          'Eis Event Trigger Response Error',          tunit='None', tdmin=min(p19), tdmax=max(p19)
  fxbaddcol, col, header, p20, 'TC_FAILED_PKTC',    'Telecommand reject counter',                tunit='None', tdmin=min(p20), tdmax=max(p20)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0,   1, 1, 'TC_FAILED_EC'
  self->write_data, lu, p1,   2, 1, 'CMD_IF_ERROR'
  self->write_data, lu, p2,   3, 1, 'PSU_STAT_ERROR'
  self->write_data, lu, p3,   4, 1, 'TC_FAILED_CMD_ID'
  self->write_data, lu, p4,   5, 1, 'ICU_ERROR_F'
  self->write_data, lu, p5,   6, 1, 'XRT_ERROR'
  self->write_data, lu, p6,   7, 1, 'HC_TARGET_T'
  self->write_data, lu, p7,   8, 1, 'HC_PSU_TO'
  self->write_data, lu, p8,   9, 1, 'MDP_LL_ERROR'
  self->write_data, lu, p9,  10, 1, 'MHC_CMD_H'
  self->write_data, lu, p10, 11, 1, 'FT_ERROR'
  self->write_data, lu, p11, 12, 1, 'AEC_WIN_ERROR'
  self->write_data, lu, p12, 13, 1, 'AEC_PARMS_ERROR'
  self->write_data, lu, p13, 14, 1, 'AEC_TIME_ERROR'
  self->write_data, lu, p14, 15, 1, 'CAM_IF_ERROR'
  self->write_data, lu, p15, 16, 1, 'SEQ_ABORT_CODE'
  self->write_data, lu, p16, 17, 1, 'CMD_ID_FAILED_INT'
  self->write_data, lu, p17, 18, 1, 'MHC_IF_ERROR'
  self->write_data, lu, p18, 19, 1, 'EEPROM_ERROR'
  self->write_data, lu, p19, 20, 1, 'ET_ERROR'
;  self->write_data, lu, p20, 21, 1, 'TC_FAILED_PKTC'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
