; need to get bakeout heater controller status

pro eis_sts1_reformatter::unpack_icu_interface_parameters, packet_data_array, cmd_if1, md_if1, stat_if1, wd_if1, cmd_if2, md_if2, stat_if2, wd_if2, m422_if1, roe_if1, roe_if2, hsl_if1, hsl_if2, m422_if2
  self->trace, 'eis_sts1_reformatter::unpack_icu_interface_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  cmd_if1  = float(packet_data_array[*].cmd_if1)
  md_if1   = float(packet_data_array[*].md_if1)
  stat_if1 = float(packet_data_array[*].stat_if1)
  wd_if1   = float(packet_data_array[*].wd_if1)
  cmd_if2  = float(packet_data_array[*].cmd_if2)
  md_if2   = float(packet_data_array[*].md_if2)
  stat_if2 = float(packet_data_array[*].stat_if2)
  wd_if2   = float(packet_data_array[*].wd_if2)
  m422_if1 = float(packet_data_array[*].m422_if1)
  roe_if1  = float(packet_data_array[*].roe_if1)
  roe_if2  = float(packet_data_array[*].roe_if2)
  hsl_if1  = float(packet_data_array[*].hsl_if1)
  hsl_if2  = float(packet_data_array[*].hsl_if2)
  m422_if2 = float(packet_data_array[*].m422_if2)

end

pro eis_sts1_reformatter::create_icu_interface_parameters_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts1_reformatter::create_icu_interface_parameters_bintable_extension'

  self->unpack_icu_interface_parameters, packet_data_array, cmd_if1, md_if1, stat_if1, wd_if1, cmd_if2, md_if2, stat_if2, wd_if2, m422_if1, roe_if1, roe_if2, hsl_if1, hsl_if2, m422_if2

  if self.padding then begin
     self->pad, cmd_if1,  pntrs
     self->pad, md_if1,   pntrs
     self->pad, stat_if1, pntrs
     self->pad, wd_if1,   pntrs
     self->pad, cmd_if2,  pntrs
     self->pad, md_if2,   pntrs
     self->pad, stat_if2, pntrs
     self->pad, wd_if2,   pntrs
     self->pad, m422_if1, pntrs
     self->pad, roe_if1,  pntrs
     self->pad, roe_if2,  pntrs
     self->pad, hsl_if1,  pntrs
     self->pad, hsl_if2,  pntrs
     self->pad, m422_if2, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, cmd_if1,  'CMD_IF_STAT1',  'Command Interface h/w Status Before Reading',        tunit='None', tdmin=min(cmd_if1),  tdmax=max(cmd_if1)
  fxbaddcol, col, header, md_if1,   'MD_IF_STAT1',   'Mission Data Interface h/w Status Before Writing',   tunit='None', tdmin=min(md_if1),   tdmax=max(md_if1)
  fxbaddcol, col, header, stat_if1, 'STAT_IF_STAT1', 'Status Interface h/w Status Before Writing',         tunit='None', tdmin=min(stat_if1), tdmax=max(stat_if1)
  fxbaddcol, col, header, wd_if1,   'WD_IF_STAT1',   'Watchdog Interface h/w Status At Boot',              tunit='None', tdmin=min(wd_if1),   tdmax=max(wd_if1)
  fxbaddcol, col, header, cmd_if2,  'CMD_IF_STAT2',  'Command Interface h/w Status After Reading',         tunit='None', tdmin=min(cmd_if2),  tdmax=max(cmd_if2)
  fxbaddcol, col, header, md_if2,   'MD_IF_STAT2',   'Mission Data Interface h/w Status After Writing',    tunit='None', tdmin=min(md_if2),   tdmax=max(md_if2)
  fxbaddcol, col, header, stat_if2, 'STAT_IF_STAT2', 'Status Interface h/w Status After Writing',          tunit='None', tdmin=min(stat_if2), tdmax=max(stat_if2)
  fxbaddcol, col, header, wd_if2,   'WD_IF_STAT2',   'Watchdog Interface h/w Status After Boot',           tunit='None', tdmin=min(wd_if2),   tdmax=max(wd_if2)
  fxbaddcol, col, header, m422_if1, 'MHC_422_STAT1', 'ICU-MHC RS422 Status Register Before Use',           tunit='None', tdmin=min(m422_if1), tdmax=max(m422_if1)
  fxbaddcol, col, header, roe_if1,  'ROE_IF_STAT1',  'CAM Read Out Electronics RS422 Register Before Use', tunit='None', tdmin=min(roe_if1),  tdmax=max(roe_if1)
  fxbaddcol, col, header, roe_if2,  'ROE_IF_STAT2',  'CAM Read Out Electronics RS422 Register After Use',  tunit='None', tdmin=min(roe_if2),  tdmax=max(roe_if2)
  fxbaddcol, col, header, hsl_if1,  'HSL_IF_STAT1',  'CAM High Speed Link Interface Status Before Use',    tunit='None', tdmin=min(hsl_if1),  tdmax=max(hsl_if1)
  fxbaddcol, col, header, hsl_if2,  'HSL_IF_STAT2',  'CAM High Speed Link Interface Status After Use',     tunit='None', tdmin=min(hsl_if2),  tdmax=max(hsl_if2)
  fxbaddcol, col, header, m422_if2, 'MHC_422_STAT2', 'ICU-MHC RS422 Status Register After Use',            tunit='None', tdmin=min(m422_if2), tdmax=max(m422_if2)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, cmd_if1,   1, 1, 'CMD_IF_STAT1'
  self->write_data, lu, md_if1,    2, 1, 'MD_IF_STAT1'
  self->write_data, lu, stat_if1,  3, 1, 'STAT_IF_STAT1'
  self->write_data, lu, wd_if1,    4, 1, 'WD_IF_STAT1'
  self->write_data, lu, cmd_if2,   5, 1, 'CMD_IF_STAT2'
  self->write_data, lu, md_if2,    6, 1, 'MD_IF_STAT2'
  self->write_data, lu, stat_if2,  7, 1, 'STAT_IF_STAT2'
  self->write_data, lu, wd_if2,    8, 1, 'WD_IF_STAT2'
  self->write_data, lu, m422_if1,  9, 1, 'MHC_422_STAT1'
  self->write_data, lu, roe_if1,  10, 1, 'ROE_IF_STAT1'
  self->write_data, lu, roe_if2,  11, 1, 'ROE_IF_STAT2'
  self->write_data, lu, hsl_if1,  12, 1, 'HSL_IF_STAT1'
  self->write_data, lu, hsl_if2,  13, 1, 'HSL_IF_STAT2'
  self->write_data, lu, m422_if2, 14, 1, 'MHC_422_STAT2'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
