; need to get bakeout heater controller status

pro eis_sts1_reformatter::unpack_icu_misc_parameters, packet_data_array, sw_id, port_rd, bc1, bc2, bc3, cmd_len, hc_target, hc_duty
  self->trace, 'eis_sts1_reformatter::unpack_icu_misc_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  sw_id     = float(packet_data_array[*].sw_id)
  port_rd   = float(packet_data_array[*].port_rd)
  bc1       = float(packet_data_array[*].bc1)
  bc2       = float(packet_data_array[*].bc2)
  bc3       = float(packet_data_array[*].bc3)
  cmd_len   = float(packet_data_array[*].cmd_len)
  hc_target = float(packet_data_array[*].hc_target)
  hc_duty   = float(packet_data_array[*].hc_duty_cycle)

end

pro eis_sts1_reformatter::create_icu_misc_parameters_bintable_extension, header, packet_data_array, pntrs
	self->trace, 'eis_sts1_reformatter::create_icu_misc_parameters_bintable_extension'

  self->unpack_icu_misc_parameters, packet_data_array, sw_id, port_rd, bc1, bc2, bc3, cmd_len, hc_target, hc_duty

  if self.padding then begin
     self->pad, sw_id,     pntrs
     self->pad, port_rd,   pntrs
     self->pad, bc1,       pntrs
     self->pad, bc2,       pntrs
     self->pad, bc3,       pntrs
     self->pad, cmd_len,   pntrs
     self->pad, hc_target, pntrs
     self->pad, hc_duty,   pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, sw_id,     'ICU_SW_ID',     'Icu Software Version',              tunit='None',      tdmin=min(sw_id),     tdmax=max(sw_id)
  fxbaddcol, col, header, port_rd,   'PORT_READ',     'Port read value',                   tunit='None',      tdmin=min(port_rd),   tdmax=max(port_rd)
  fxbaddcol, col, header, bc1,       'LAST_BC1_R',    'Last Command Id Received',          tunit='None',      tdmin=min(bc1),       tdmax=max(bc1)
  fxbaddcol, col, header, bc2,       'LAST_BC2_R',    'Last Command BC2 Received',         tunit='None',      tdmin=min(bc2),       tdmax=max(bc2)
  fxbaddcol, col, header, bc3,       'LAST_BC3_R',    'Last Command BC3 Received',         tunit='None',      tdmin=min(bc3),       tdmax=max(bc3)
  fxbaddcol, col, header, cmd_len,   'LAST_CMD_L_R',  'Last Command Length Received',      tunit='None',      tdmin=min(cmd_len),   tdmax=max(cmd_len)
  fxbaddcol, col, header, hc_target, 'HC_TARGET_T',   'Bakeout Heater Target Temperature', tunit='Degrees C', tdmin=min(hc_target), tdmax=max(hc_target)
  fxbaddcol, col, header, hc_duty,   'HC_DUTY_CYCLE', 'Bakeout Heater Duty Cycle',         tunit='None',      tdmin=min(hc_duty),   tdmax=max(hc_duty)


  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, sw_id,     1, 1, 'ICU_SW_ID'
  self->write_data, lu, port_rd,   2, 1, 'PORT_READ'
  self->write_data, lu, bc1,       3, 1, 'LAST_BC1_R'
  self->write_data, lu, bc2,       4, 1, 'LAST_BC2_R'
  self->write_data, lu, bc3,       5, 1, 'LAST_BC3_R'
  self->write_data, lu, cmd_len,   6, 1, 'LAST_CMD_L_R'
  self->write_data, lu, hc_target, 7, 1, 'HC_TARGET_T'
  self->write_data, lu, hc_duty,   8, 1, 'HC_DUTY_CYCLE'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
