
pro eis_sts1_reformatter::unpack_icu_psu_currents, packet_data_array, p2v5i, p5vi, p15vi, n15vi, mbus28vi
  self->trace, 'eis_sts1_reformatter::unpack_icu_psu_currents'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  p2v5i    = float(packet_data_array[*].p2v5i)
  p5vi     = float(packet_data_array[*].p5vi)
  p15vi    = float(packet_data_array[*].p15vi)
  n15vi    = float(packet_data_array[*].n15vi)
  mbus28vi = float(packet_data_array[*].mbus28vi)

end

pro eis_sts1_reformatter::create_icu_psu_currents_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts1_reformatter::create_icu_psu_currents_bintable_extension'

  self->unpack_icu_psu_currents, packet_data_array, p2v5i, p5vi, p15vi, n15vi, mbus28vi

  if self.padding then begin
     self->pad, p2v5i,    pntrs
     self->pad, p5vi,     pntrs
     self->pad, p15vi,    pntrs
     self->pad, n15vi,    pntrs
     self->pad, mbus28vi, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p2v5i,    'ICU_P2I5', 'PSU +2.5v current',     tunit='Amps', tdmin=min(p2v5i),    tdmax=max(p2v5i)
  fxbaddcol, col, header, p5vi,     'ICU_P5I',  'PSU +5v current',       tunit='Amps', tdmin=min(p5vi),     tdmax=max(p5vi)
  fxbaddcol, col, header, p15vi,    'ICU_P15I', 'PSU +15v current',      tunit='Amps', tdmin=min(p15vi),    tdmax=max(p15vi)
  fxbaddcol, col, header, n15vi,    'ICU_N15I', 'PSU -15v current',      tunit='Amps', tdmin=min(n15vi),    tdmax=max(n15vi)
  fxbaddcol, col, header, mbus28vi, 'MBUS_28I', 'Main bus +28v current', tunit='Amps', tdmin=min(mbus28vi), tdmax=max(mbus28vi)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p2v5i,    1, 1, 'ICU_P2I5'
  self->write_data, lu, p5vi,     2, 1, 'ICU_P5I'
  self->write_data, lu, p15vi,    3, 1, 'ICU_P15I'
  self->write_data, lu, n15vi,    4, 1, 'ICU_N15I'
  self->write_data, lu, mbus28vi, 5, 1, 'MBUS_28I'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
