
pro eis_sts1_reformatter::unpack_icu_psu_temperatures, packet_data_array, ccda, ccdb, proc
  self->trace, 'eis_sts1_reformatter::unpack_icu_psu_temperatures'

  ccda = float(packet_data_array[*].ccda)
  ccdb = float(packet_data_array[*].ccdb)
  proc = float(packet_data_array[*].proc)

end


pro eis_sts1_reformatter::create_icu_psu_temperatures_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts1_reformatter::create_icu_psu_temperatures_bintable_extension'

  self->unpack_icu_psu_temperatures, packet_data_array, ccda, ccdb, proc

  if self.padding then begin
     self->pad, ccda, pntrs
     self->pad, ccdb, pntrs
     self->pad, proc, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, ccda, 'CCDA_TEMP',     'CCD A Temperature',         tunit='Degrees C', tdmin=min(ccda), tdmax=max(ccda)
  fxbaddcol, col, header, ccdb, 'CCDB_TEMP',     'CCD B Temperature',         tunit='Degrees C', tdmin=min(ccdb), tdmax=max(ccdb)
  fxbaddcol, col, header, proc, 'ICU_PROC_TEMP', 'ICU Processor Temperature', tunit='Degrees C', tdmin=min(proc), tdmax=max(proc)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, ccda, 1, 1, 'CCDA_TEMP'
  self->write_data, lu, ccdb, 2, 1, 'CCDB_TEMP'
  self->write_data, lu, proc, 3, 1, 'ICU_PROC_TEMP'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
