
pro eis_sts1_reformatter::unpack_icu_psu_voltages, packet_data_array, p2v5, p5v, p15v, n15v, mbus28v
  self->trace, 'eis_sts1_reformatter::unpack_icu_psu_voltages'
  
  p2v5    = float(packet_data_array[*].p2v5)
  p5v     = float(packet_data_array[*].p5v)
  p15v    = float(packet_data_array[*].p15v)
  n15v    = float(packet_data_array[*].n15v)
  mbus28v = float(packet_data_array[*].mbus28v)
  ;;;mbus28v = self->pad, float(packet_data_array[*].mbus28v)
  
end

pro eis_sts1_reformatter::create_icu_psu_voltages_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts1_reformatter::create_icu_psu_voltages_bintable_extension'
  
  self->unpack_icu_psu_voltages, packet_data_array, p2v5, p5v, p15v, n15v, mbus28v

  if self.padding then begin
     self->pad, p2v5,    pntrs
     self->pad, p5v,     pntrs
     self->pad, p15v,    pntrs
     self->pad, n15v,    pntrs
     self->pad, mbus28v, pntrs
  endif
  
  ; Pad the data to fill in the missing values (unless this is done in unpack...)
  ;;self->pad_data, p2v5
  ;;self->pad_data, p5v ; etc
  ; or
  ;;self->pad_icu_psu_voltage_data, p2v5, p5v, p15v, n15v, mbus28v ; calls self->pad_data

  ; Create the column descriptions
  ;fxbaddcol, col, header, p2v5,    'PSU +2.5 volts',     'Volts',  tunit='Volts', tdmin=min(p2v5),    tdmax=max(p2v5)
  ;fxbaddcol, col, header, p5v,     'PSU +5 volts',       'Volts',  tunit='Volts', tdmin=min(p5v),     tdmax=max(p5v)
  ;fxbaddcol, col, header, p15v,    'PSU +15 volts',      'Volts',  tunit='Volts', tdmin=min(p15v),    tdmax=max(p15v)
  ;fxbaddcol, col, header, n15v,    'PSU -15 volts',      'Volts',  tunit='Volts', tdmin=min(n15v),    tdmax=max(n15v)
  ;fxbaddcol, col, header, mbus28v, 'Main bus +28 volts', 'Volts',  tunit='Volts', tdmin=min(mbus28v), tdmax=max(mbus28v)

;foo=string(min(uint(p2v5)))
;print,foo
;help,foo
;stop,foo
  ;fxbaddcol, col, header, p2v5,    'P2V5',     'PSU +2.5 volts',  tunit='Volts', tdmin=strtrim(string(min(p2v5)),2),    tdmax=strtrim(string(max(p2v5)),2)
  fxbaddcol, col, header, p2v5,    'ICU_P2V5', 'PSU +2.5 volts',     tunit='Volts', tdmin=min(p2v5),    tdmax=max(p2v5)   , tdisp='F7.3' ;, TDESC='Conversion routine: eis_convert_icu_voltage_p2p5v'
;  fxaddpar, header, 'convert', 'eis_convert_icu_voltage_p2p5v',        'Conversion routine to engineering units'
  fxbaddcol, col, header, p5v,     'ICU_P5V',  'PSU +5 volts',       tunit='Volts', tdmin=min(p5v),     tdmax=max(p5v)    , tdisp='F7.3'
  fxbaddcol, col, header, p15v,    'ICU_P15V', 'PSU +15 volts',      tunit='Volts', tdmin=min(p15v),    tdmax=max(p15v)   , tdisp='F7.3'
  fxbaddcol, col, header, n15v,    'ICU_N15V', 'PSU -15 volts',      tunit='Volts', tdmin=min(n15v),    tdmax=max(n15v)   , tdisp='F7.3'
  fxbaddcol, col, header, mbus28v, 'MBUS_28V', 'Main bus +28 volts', tunit='Volts', tdmin=min(mbus28v), tdmax=max(mbus28v), tdisp='F7.3'

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  ;self->write_data, lu, p2v5,    1, 1, 'P2V5'
  ;self->write_data, lu, p5v,     2, 1, 'P5V'
  ;self->write_data, lu, p15v,    3, 1, 'P15V'
  ;self->write_data, lu, n15v,    4, 1, 'N15V'
  ;self->write_data, lu, mbus28v, 5, 1, 'MBUS28V'

  self->write_data, lu, p2v5,    1, 1, 'ICU_P2V5'
  self->write_data, lu, p5v,     2, 1, 'ICU_P5V'
  self->write_data, lu, p15v,    3, 1, 'ICU_P15V'
  self->write_data, lu, n15v,    4, 1, 'ICU_N15V'
  self->write_data, lu, mbus28v, 5, 1, 'MBUS_28V'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
