
pro eis_sts1_reformatter::unpack_icu_science_parameters, packet_data_array, seqi, seqp, lli
  self->trace, 'eis_sts1_reformatter::unpack_icu_science_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  seqi = float(packet_data_array[*].seqi)
  seqp = float(packet_data_array[*].seqp)
  lli  = float(packet_data_array[*].lli)

end

pro eis_sts1_reformatter::create_icu_science_parameters_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts1_reformatter::create_icu_science_parameters_bintable_extension'

  self->unpack_icu_science_parameters, packet_data_array, seqi, seqp, lli

  if self.padding then begin
     self->pad, seqi, pntrs
     self->pad, seqp, pntrs
     self->pad, lli,  pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, seqi, 'SEQ_I', 'Current Sequence Index',   tunit='None', tdmin=min(seqi), tdmax=max(seqi)
  fxbaddcol, col, header, seqp, 'SEQ_P', 'Current Sequence Pointer', tunit='None', tdmin=min(seqp), tdmax=max(seqp)
  fxbaddcol, col, header, lli,  'LL_I',  'Current Linelist Index',   tunit='None', tdmin=min(lli),  tdmax=max(lli)


  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, seqi, 1, 1, 'SEQ_I'
  self->write_data, lu, seqp, 2, 1, 'SEQ_P'
  self->write_data, lu, lli,  3, 1, 'LL_I'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
