
pro eis_sts1_reformatter::unpack_psu_status_parameters, packet_data_array, p0,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14
  self->trace, 'eis_sts1_reformatter::unpack_psu_status_parameters'

  ; p2v5 = self->pad_data(packet_data_array.p2v5)
  p0  = float((packet_data_array[*].psu_mark and '01'X) eq '01'X)
  p1  = float((packet_data_array[*].psu_mark and '04'X) eq '04'X)
  p2  = float((packet_data_array[*].psu_mark and '08'X) eq '08'X)
  p3  = float((packet_data_array[*].psu_mark and '10'X) eq '10'X)
  p4  = float((packet_data_array[*].psu_mark and '20'X) eq '20'X)
  p5  = float((packet_data_array[*].psu_mark and '40'X) eq '40'X)
  p6  = float((packet_data_array[*].psu_mark and '80'X) eq '80'X)
  p7  = float((packet_data_array[*].p28v and '01'X) eq '01'X)
  p8  = float((packet_data_array[*].p28v and '02'X) eq '02'X)
  p9  = float((packet_data_array[*].p28v and '04'X) eq '04'X)
  p10 = float((packet_data_array[*].p28v and '08'X) eq '08'X)
  p11 = float((packet_data_array[*].p28v and '10'X) eq '10'X)
  p12 = float((packet_data_array[*].p28v and '20'X) eq '20'X)
  p13 = float((packet_data_array[*].p28v and '40'X) eq '40'X)
  p14 = float((packet_data_array[*].p28v and '80'X) eq '80'X)
end

pro eis_sts1_reformatter::create_psu_status_parameters_bintable_extension, header, packet_data_array, pntrs
	self->trace, 'eis_sts1_reformatter::create_psu_status_parameters_bintable_extension'

  self->unpack_psu_status_parameters, packet_data_array, p0,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14

  if self.padding then begin
     self->pad, p0,  pntrs
     self->pad, p1,  pntrs
     self->pad, p2,  pntrs
     self->pad, p3,  pntrs
     self->pad, p4,  pntrs
     self->pad, p5,  pntrs
     self->pad, p6,  pntrs
     self->pad, p7,  pntrs
     self->pad, p8,  pntrs
     self->pad, p9,  pntrs
     self->pad, p10, pntrs
     self->pad, p11, pntrs
     self->pad, p12, pntrs
     self->pad, p13, pntrs
     self->pad, p14, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header,  p0, 'PSU_MARK',           'PSU HK table marker bit',                   tunit='None', tdmin=min(p0), tdmax=max(p0)
  fxbaddcol, col, header,  p1, 'PSU_CCDB_HTR_EN',    'CCD B bake-out heater status',              tunit='None', tdmin=min(p1), tdmax=max(p1)
  fxbaddcol, col, header,  p2, 'PSU_CCDA_HTR_EN',    'CCD A bake-out heater status',              tunit='None', tdmin=min(p2), tdmax=max(p2)
  fxbaddcol, col, header,  p3, 'PSU_CCDB_BHTR_STAT', 'CCD B bake-out heater ON/OFF',              tunit='None', tdmin=min(p3), tdmax=max(p3)
  fxbaddcol, col, header,  p4, 'PSU_CCDA_BHTR_STAT', 'CCD A bake-out heater ON/OFF',              tunit='None', tdmin=min(p4), tdmax=max(p4)
  fxbaddcol, col, header,  p5, 'PSU_MHC_HTR_P28V',   'MHC operational heater +28V supply status', tunit='None', tdmin=min(p5), tdmax=max(p5)
  fxbaddcol, col, header,  p6, 'PSU_MHC_MECH_P28V',  'MHC mechanism +28V supply status',          tunit='None', tdmin=min(p6), tdmax=max(p6)
  fxbaddcol, col, header,  p7, 'PSU_MHC_ELEC_P28V',  'MHC electronics +28V supply status',        tunit='None', tdmin=min(p7), tdmax=max(p7)
  fxbaddcol, col, header,  p8, 'PSU_MHC_MHTR',       'MHC make-up heater status',                 tunit='None', tdmin=min(p8), tdmax=max(p8)
  fxbaddcol, col, header,  p9, 'PSU_CAM_MHTR',       'CAM make-up heater status',                 tunit='None', tdmin=min(p9), tdmax=max(p9)
  fxbaddcol, col, header, p10, 'PSU_CAM_P39V',       'CAM +39V supply status',                    tunit='None', tdmin=min(p10), tdmax=max(p10)
  fxbaddcol, col, header, p11, 'PSU_CAM_N8V',        'CAM negative 8V supply status',             tunit='None', tdmin=min(p11), tdmax=max(p11)
  fxbaddcol, col, header, p12, 'PSU_CAM_P7V',        'CAM +7V supply status',                     tunit='None', tdmin=min(p12), tdmax=max(p12)
  fxbaddcol, col, header, p13, 'PSU_CAM_P8V',        'CAM +8V supply status',                     tunit='None', tdmin=min(p13), tdmax=max(p13)
  fxbaddcol, col, header, p14, 'PSU_CAM_P13V',       'CAM +13V supply status',                    tunit='None', tdmin=min(p14), tdmax=max(p14)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu,  p0,  1, 1, 'PSU_MARK'
  self->write_data, lu,  p1,  2, 1, 'PSU_CCDB_HTR_EN'
  self->write_data, lu,  p2,  3, 1, 'PSU_CCDA_HTR_EN'
  self->write_data, lu,  p3,  4, 1, 'PSU_CCDB_BHTR_STAT'
  self->write_data, lu,  p4,  5, 1, 'PSU_CCDA_BHTR_STAT'
  self->write_data, lu,  p5,  6, 1, 'PSU_MHC_HTR_P28V'
  self->write_data, lu,  p6,  7, 1, 'PSU_MHC_MECH_P28V'
  self->write_data, lu,  p7,  8, 1, 'PSU_MHC_ELEC_P28V'
  self->write_data, lu,  p8,  9, 1, 'PSU_MHC_MHTR'
  self->write_data, lu,  p9, 10, 1, 'PSU_CAM_MHTR'
  self->write_data, lu, p10, 11, 1, 'PSU_CAM_P39V'
  self->write_data, lu, p11, 12, 1, 'PSU_CAM_N8V'
  self->write_data, lu, p12, 13, 1, 'PSU_CAM_P7V'
  self->write_data, lu, p13, 14, 1, 'PSU_CAM_P8V'
  self->write_data, lu, p14, 15, 1, 'PSU_CAM_P13V'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
