
pro eis_sts2_reformatter::create_bintable_extension, extension_name, extension_comment, packet_data_array, pntrs
  self->trace, 'eis_sts2_reformatter::create_bintable_extension'

  if self->create_bintable_extension_header(extension_name, extension_comment, header) then begin

     self->add_primary_header_keywords, header

     case extension_name of
        'CAMERA VOLTAGES'       : self->create_cam_voltages_bintable_extension,        header, packet_data_array, pntrs
        'CAMERA CURRENTS'       : self->create_cam_currents_bintable_extension,        header, packet_data_array, pntrs
        'CAMERA BIASES'         : self->create_cam_biases_bintable_extension,          header, packet_data_array, pntrs
        'CAMERA PSU VOLTAGES'   : self->create_cam_psu_voltages_bintable_extension,    header, packet_data_array, pntrs
        'CAMERA PSU CURRENTS'   : self->create_cam_psu_currents_bintable_extension,    header, packet_data_array, pntrs
        'CAMERA ICU PARAMETERS' : self->create_cam_icu_parameters_bintable_extension,  header, packet_data_array, pntrs
        'CAMERA MISC'           : self->create_cam_misc_bintable_extension,            header, packet_data_array, pntrs
        'CAMERA TEMPERATURES'   : self->create_cam_temperatures_bintable_extension,    header, packet_data_array, pntrs
        'SPACECRAFT'            : self->create_spacecraft_bintable_extension,          header, packet_data_array, pntrs
        else                    : self->log, 'Unknown extension name: ' + extension_name
     endcase
     
  endif
  
end
