
pro eis_sts2_reformatter::unpack_cam_biases, packet_data_array, voda, vrda, vssa, vodb, vrdb, vssb, vod, vrd, vss
  self->trace, 'eis_sts2_reformatter::unpack_cam_biases'

  voda = float(packet_data_array[*].voda)
  vrda = float(packet_data_array[*].vrda)
  vssa = float(packet_data_array[*].vssa)
  vodb = float(packet_data_array[*].vodb)
  vrdb = float(packet_data_array[*].vrdb)
  vssb = float(packet_data_array[*].vssb)
  vod  = float(packet_data_array[*].vod)
  vrd  = float(packet_data_array[*].vrd)
  vss  = float(packet_data_array[*].vss)

end

pro eis_sts2_reformatter::create_cam_biases_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts2_reformatter::create_cam_biases_bintable_extension'

  self->unpack_cam_biases, packet_data_array, voda, vrda, vssa, vodb, vrdb, vssb, vod, vrd, vss

  ; Pad the data to fill in the missing values (unless this is done in unpack...)
  ;;self->pad_data, p2v5
  ;;self->pad_data, p5v ; etc
  ; or
  ;;self->pad_icu_psu_voltage_data, p2v5, p5v, p15v, n15v, mbus28v ; calls self->pad_data

  if self.padding then begin
     self->pad, voda, pntrs
     self->pad, vrda, pntrs
     self->pad, vssa, pntrs
     self->pad, vodb, pntrs
     self->pad, vrdb, pntrs
     self->pad, vssb, pntrs
     self->pad, vod,  pntrs
     self->pad, vrd,  pntrs
     self->pad, vss,  pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, voda, 'CAM_VOD_A', 'Camera CCD-A VOD',       tunit='Volts', tdmin=min(voda), tdmax=max(voda)
  fxbaddcol, col, header, vrda, 'CAM_VRD_A', 'Camera CCD-A VRD',       tunit='Volts', tdmin=min(vrda), tdmax=max(vrda)
  fxbaddcol, col, header, vssa, 'CAM_VSS_A', 'Camera CCD-A VSS',       tunit='Volts', tdmin=min(vssa), tdmax=max(vssa)
  fxbaddcol, col, header, vodb, 'CAM_VOD_B', 'Camera CCD-B VOD',       tunit='Volts', tdmin=min(vodb), tdmax=max(vodb)
  fxbaddcol, col, header, vrdb, 'CAM_VRD_B', 'Camera CCD-B VRD',       tunit='Volts', tdmin=min(vrdb), tdmax=max(vrdb)
  fxbaddcol, col, header, vssb, 'CAM_VSS_B', 'Camera CCD-B VSS',       tunit='Volts', tdmin=min(vssb), tdmax=max(vssb)
  fxbaddcol, col, header, vod,  'CAM_VOD',   'Camera Bias Register 1', tunit='Volts', tdmin=min(vod),  tdmax=max(vod)
  fxbaddcol, col, header, vrd,  'CAM_VRD',   'Camera Bias Register 2', tunit='Volts', tdmin=min(vrd),  tdmax=max(vrd)
  fxbaddcol, col, header, vss,  'CAM_VSS',   'Camera Bias Register 3', tunit='Volts', tdmin=min(vss),  tdmax=max(vss)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, voda, 1,  1, 'CAM_VOD_A'
  self->write_data, lu, vrda, 2,  1, 'CAM_VRD_A'
  self->write_data, lu, vssa, 3,  1, 'CAM_VSS_A'
  self->write_data, lu, vodb, 4,  1, 'CAM_VOD_B'
  self->write_data, lu, vrdb, 5,  1, 'CAM_VRD_B'
  self->write_data, lu, vssb, 6,  1, 'CAM_VSS_B'
  self->write_data, lu, vod,  7,  1, 'CAM_VOD'
  self->write_data, lu, vrd,  8,  1, 'CAM_VRD'
  self->write_data, lu, vss,  9,  1, 'CAM_VSS'


  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
