
pro eis_sts2_reformatter::unpack_cam_currents, packet_data_array, p5v, p2v5, ccdap5v, ccdbp5v, ccdan5v, ccdbn5v, ccdap36v, ccdbp36v, ccdap12v, ccdbp12v
  self->trace, 'eis_sts2_reformatter::unpack_cam_currents'

  p5v      = float(packet_data_array[*].p5vi_dig)
  p2v5     = float(packet_data_array[*].p2v5i_dig)
  ccdap5v  = float(packet_data_array[*].p5vi_ana)
  ccdbp5v  = float(packet_data_array[*].p5vi_anb)
  ccdan5v  = float(packet_data_array[*].n5vi_ana)
  ccdbn5v  = float(packet_data_array[*].n5vi_anb)
  ccdap36v = float(packet_data_array[*].p36vi_a)
  ccdbp36v = float(packet_data_array[*].p36vi_b)
  ccdap12v = float(packet_data_array[*].p12vi_a)
  ccdbp12v = float(packet_data_array[*].p12vi_b)
end

pro eis_sts2_reformatter::create_cam_currents_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts2_reformatter::create_cam_currents_bintable_extension'

  self->unpack_cam_currents, packet_data_array, p5v, p2v5, ccdap5v, ccdbp5v, ccdan5v, ccdbn5v, ccdap36v, ccdbp36v, ccdap12v, ccdbp12v

  if self.padding then begin
     self->pad, p5v,      pntrs
     self->pad, p2v5,     pntrs
     self->pad, ccdap5v,  pntrs
     self->pad, ccdbp5v,  pntrs
     self->pad, ccdan5v,  pntrs
     self->pad, ccdbn5v,  pntrs
     self->pad, ccdap36v, pntrs
     self->pad, ccdbp36v, pntrs
     self->pad, ccdap12v, pntrs
     self->pad, ccdbp12v, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p5v,      'CAM_P5VI_DIG',  'CAM +5.1V Digital Current',     tunit='Amps', tdmin=min(p5v),      tdmax=max(p5v)
  fxbaddcol, col, header, p2v5,     'CAM_P2V5I_DIG', 'CAM +2.5V Digital Current',     tunit='Amps', tdmin=min(p2v5),     tdmax=max(p2v5)
  fxbaddcol, col, header, ccdap5v,  'CAM_P5VI_AN_A', 'CAM +5V CCD-A Analog Current',  tunit='Amps', tdmin=min(ccdap5v),  tdmax=max(ccdap5v)
  fxbaddcol, col, header, ccdbp5v,  'CAM_P5VI_AN_B', 'CAM +5V CCD-B Analog Current',  tunit='Amps', tdmin=min(ccdbp5v),  tdmax=max(ccdbp5v)
  fxbaddcol, col, header, ccdan5v,  'CAM_N5VI_AN_A', 'CAM -5V CCD-A Analog Current',  tunit='Amps', tdmin=min(ccdan5v),  tdmax=max(ccdan5v)
  fxbaddcol, col, header, ccdbn5v,  'CAM_N5VI_AN_B', 'CAM -5V CCD-B Analog Current',  tunit='Amps', tdmin=min(ccdbn5v),  tdmax=max(ccdbn5v)
  fxbaddcol, col, header, ccdap36v, 'CAM_P36VI_A',   'CAM +36V CCD-A Analog Current', tunit='Amps', tdmin=min(ccdap36v), tdmax=max(ccdap36v)
  fxbaddcol, col, header, ccdbp36v, 'CAM_P36VI_B',   'CAM +36V CCD-B Analog Current', tunit='Amps', tdmin=min(ccdbp36v), tdmax=max(ccdbp36v)
  fxbaddcol, col, header, ccdap12v, 'CAM_P12VI_A',   'CAM +12V CCD-A Analog Current', tunit='Amps', tdmin=min(ccdap12v), tdmax=max(ccdap12v)
  fxbaddcol, col, header, ccdbp12v, 'CAM_P12VI_B',   'CAM +12V CCD-B Analog Current', tunit='Amps', tdmin=min(ccdbp12v), tdmax=max(ccdbp12v)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p5v,      1,  1, 'CAM_P5VI_DIG'
  self->write_data, lu, p2v5,     2,  1, 'CAM_P2V5I_DIG'
  self->write_data, lu, ccdap5v,  3,  1, 'CAM_P5VI_AN_A'
  self->write_data, lu, ccdbp5v,  4,  1, 'CAM_P5VI_AN_B'
  self->write_data, lu, ccdan5v,  5,  1, 'CAM_N5VI_AN_A'
  self->write_data, lu, ccdbn5v,  6,  1, 'CAM_N5VI_AN_B'
  self->write_data, lu, ccdap36v, 7,  1, 'CAM_P36VI_A'
  self->write_data, lu, ccdbp36v, 8,  1, 'CAM_P36VI_B'
  self->write_data, lu, ccdap12v, 9,  1, 'CAM_P12VI_A'
  self->write_data, lu, ccdbp12v, 10, 1, 'CAM_P12VI_B'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
