
pro eis_sts2_reformatter::unpack_cam_icu_parameters, packet_data_array, p0,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15,p16,p17,p18,p19,p20,p21,p22
  self->trace, 'eis_sts2_reformatter::unpack_cam_icu_parameters'

  p0  = float(packet_data_array[*].buf_add)
  p1  = float(packet_data_array[*].buf_count)
  p2  = float(packet_data_array[*].alive)
  p3  = float(packet_data_array[*].xrt_x)
  p4  = float(packet_data_array[*].xrt_y)
  p5  = float(packet_data_array[*].cmir_pos)
  p6  = float(packet_data_array[*].fmir_off)
  p7  = float(packet_data_array[*].fmir_slp)
  p8  = float(packet_data_array[*].cmir_slp)
  p9  = float(packet_data_array[*].res_px)
  p10 = float(packet_data_array[*].res_nx)
  p11 = float(packet_data_array[*].resp)
  p12 = float(packet_data_array[*].stime)
  p13 = float(packet_data_array[*].span)
  p14 = float(packet_data_array[*].xfov)
  p15 = float(packet_data_array[*].xf)
  p16 = float(packet_data_array[*].yf)
  p17 = float(packet_data_array[*].xbin_pk)
  p18 = float(packet_data_array[*].ybin_pk)
  p19 = float(packet_data_array[*].etxf)
  p20 = float(packet_data_array[*].etyf)
  p21 = float(packet_data_array[*].etxbin_pk)
  p22 = float(packet_data_array[*].etybin_pk)
end

pro eis_sts2_reformatter::create_cam_icu_parameters_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts2_reformatter::create_cam_icu_parameters_bintable_extension'

  self->unpack_cam_icu_parameters, packet_data_array, p0,p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15,p16,p17,p18,p19,p20,p21,p22

  if self.padding then begin
     self->pad, p0,  pntrs
     self->pad, p1,  pntrs
     self->pad, p2,  pntrs
     self->pad, p3,  pntrs
     self->pad, p4,  pntrs
     self->pad, p5,  pntrs
     self->pad, p6,  pntrs
     self->pad, p7,  pntrs
     self->pad, p8,  pntrs
     self->pad, p9,  pntrs
     self->pad, p10, pntrs
     self->pad, p11, pntrs
     self->pad, p12, pntrs
     self->pad, p13, pntrs
     self->pad, p14, pntrs
     self->pad, p15, pntrs
     self->pad, p16, pntrs
     self->pad, p17, pntrs
     self->pad, p18, pntrs
     self->pad, p19, pntrs
     self->pad, p20, pntrs
     self->pad, p21, pntrs
     self->pad, p22, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0,  'CCD_BUF_ADD_F',   'CCD buffer address failed',                          tunit='None',         tdmin=min(p0),  tdmax=max(p0)
  fxbaddcol, col, header, p1,  'CCD_BUF_COUNT',   'Total read-write errors',                            tunit='None',         tdmin=min(p1),  tdmax=max(p1)
  fxbaddcol, col, header, p2,  'MHC_ALIVE_SYSEC', 'Time of ICU-MHC comms failure',                      tunit='None',         tdmin=min(p2),  tdmax=max(p2)
  fxbaddcol, col, header, p3,  'EIS_XRT_X',       'EIS translation of XRT flare in x',                  tunit='arc seconds',  tdmin=min(p3),  tdmax=max(p3)
  fxbaddcol, col, header, p4,  'EIS_XRT_Y',       'EIS translation of XRT flare in y',                  tunit='arc seconds',  tdmin=min(p4),  tdmax=max(p4)
  fxbaddcol, col, header, p5,  'CMIR_POS_ARCS',   'Coarse mirror position in arc seconds',              tunit='arc seconds',  tdmin=min(p5),  tdmax=max(p5)
  fxbaddcol, col, header, p6,  'FMIR_OFFSET',     'Fine mirror set point offset setting',               tunit='None',         tdmin=min(p6),  tdmax=max(p6)
  fxbaddcol, col, header, p7,  'FMIR_SLOPE',      'Fine mirror slope setting',                          tunit='None',         tdmin=min(p7),  tdmax=max(p7)
  fxbaddcol, col, header, p8,  'CMIR_SLOPE',      'Coarse mirror slope setting',                        tunit='None',         tdmin=min(p8),  tdmax=max(p8)
  fxbaddcol, col, header, p9,  'CMIR_RES_PX',     'Coarse mirror positive resolver limit (+x)',         tunit='None',         tdmin=min(p9),  tdmax=max(p9)
  fxbaddcol, col, header, p10, 'CMIR_RES_NX',     'Coarse mirror negative resolver limit (-x)',         tunit='None',         tdmin=min(p10), tdmax=max(p10)
  fxbaddcol, col, header, p11, 'MHC_RESPONSE_TO', 'MHC response time out setting',                      tunit='seconds',      tdmin=min(p11), tdmax=max(p11)
  fxbaddcol, col, header, p12, 'FMIR_S_TIME',     'Fine mirror settling time',                          tunit='milliseconds', tdmin=min(p12), tdmax=max(p12)
  fxbaddcol, col, header, p13, 'CMIR_SPAN_ARCS',  'Coarse mirror span setting',                         tunit='src seconds',  tdmin=min(p13), tdmax=max(p13)
  fxbaddcol, col, header, p14, 'EIS_XFOV',        'EIS field of view in x',                             tunit='arc seconds',  tdmin=min(p14), tdmax=max(p14)
  fxbaddcol, col, header, p15, 'FT_XF',           'EIS flare trigger x pixel location',                 tunit='pixels',       tdmin=min(p15), tdmax=max(p15)
  fxbaddcol, col, header, p16, 'FT_YF',           'EIS flare trigger y pixel location',                 tunit='pixels',       tdmin=min(p16), tdmax=max(p16)
  fxbaddcol, col, header, p17, 'FT_XBIN_PEAK',    'EIS flare trigger x-bin peak value',                 tunit='Pixels',       tdmin=min(p17), tdmax=max(p17)
  fxbaddcol, col, header, p18, 'FT_YBIN_PEAK',    'EIS flare trigger y-bin peak value',                 tunit='Pixels',       tdmin=min(p18), tdmax=max(p18)
  fxbaddcol, col, header, p19, 'ET_XF',           'EIS event trigger x location',                       tunit='steps',        tdmin=min(p19), tdmax=max(p19)
  fxbaddcol, col, header, p20, 'ET_YF',           'EIS event trigger y location within detection line', tunit='pixels',       tdmin=min(p20), tdmax=max(p20)
  fxbaddcol, col, header, p21, 'ET_XBIN_PEAK',    'EIS event trigger x-bin peak (dispersion sum)',      tunit='Pixels',       tdmin=min(p21), tdmax=max(p21)
  fxbaddcol, col, header, p22, 'ET_YBIN_PEAK',    'EIS event trigger y-bin peak (spatial sum)',         tunit='Pixels',       tdmin=min(p22), tdmax=max(p22)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0,   1, 1, 'CCD_BUF_ADD_F'
  self->write_data, lu, p1,   2, 1, 'CCD_BUF_COUNT'
  self->write_data, lu, p2,   3, 1, 'MHC_ALIVE_SYSEC'
  self->write_data, lu, p3,   4, 1, 'EIS_XRT_X'
  self->write_data, lu, p4,   5, 1, 'EIS_XRT_Y'
  self->write_data, lu, p5,   6, 1, 'CMIR_POS_ARCS'
  self->write_data, lu, p6,   7, 1, 'FMIR_OFFSET'
  self->write_data, lu, p7,   8, 1, 'FMIR_SLOPE'
  self->write_data, lu, p8,   9, 1, 'CMIR_SLOPE'
  self->write_data, lu, p9,  10, 1, 'CMIR_RES_PX'
  self->write_data, lu, p10, 11, 1, 'CMIR_RES_NX'
  self->write_data, lu, p11, 12, 1, 'MHC_RESPONSE_TO'
  self->write_data, lu, p12, 13, 1, 'FMIR_S_TIME'
  self->write_data, lu, p13, 14, 1, 'CMIR_SPAN_ARCS'
  self->write_data, lu, p14, 15, 1, 'EIS_XFOV'
  self->write_data, lu, p15, 16, 1, 'FT_XF'
  self->write_data, lu, p16, 17, 1, 'FT_YF'
  self->write_data, lu, p17, 18, 1, 'FT_XBIN_PEAK'
  self->write_data, lu, p18, 19, 1, 'FT_YBIN_PEAK'
  self->write_data, lu, p19, 20, 1, 'ET_XF'
  self->write_data, lu, p20, 21, 1, 'ET_YF'
  self->write_data, lu, p21, 22, 1, 'ET_XBIN_PEAK'
  self->write_data, lu, p22, 23, 1, 'ET_YBIN_PEAK'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
