
pro eis_sts2_reformatter::unpack_cam_misc, packet_data_array, p0, p1, p2
  self->trace, 'eis_sts2_reformatter::unpack_cam_misc'

  p0  = float(packet_data_array[*].reg1)
  p1  = float(packet_data_array[*].reg2)
  p2  = float(packet_data_array[*].seu)

end

pro eis_sts2_reformatter::create_cam_misc_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts2_reformatter::create_cam_misc_bintable_extension'

  self->unpack_cam_misc, packet_data_array, p0, p1, p2

  if self.padding then begin
     self->pad, p0,  pntrs
     self->pad, p1,  pntrs
     self->pad, p2,  pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0, 'CAM_CTL_REG1',    'Control register 1', tunit='None', tdmin=min(p0), tdmax=max(p0)
  fxbaddcol, col, header, p1, 'CAM_CTL_REG2',    'Control register 2', tunit='None', tdmin=min(p1), tdmax=max(p1)
  fxbaddcol, col, header, p2, 'CAM_SEU_COUNTER', 'SEU counter',        tunit='None', tdmin=min(p2), tdmax=max(p2)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0, 1,  1, 'CAM_CTL_REG1'
  self->write_data, lu, p1, 2,  1, 'CAM_CTL_REG2'
  self->write_data, lu, p2, 3,  1, 'CAM_SEU_COUNTER'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
