
pro eis_sts2_reformatter::unpack_cam_psu_currents, packet_data_array, p39v, p7v, n8v, p8v, p13v
  self->trace, 'eis_sts2_reformatter::unpack_cam_psu_currents'

  p39v = float(packet_data_array[*].p39vi)
  p7v  = float(packet_data_array[*].p7vi)
  n8v  = float(packet_data_array[*].n8vi)
  p8v  = float(packet_data_array[*].p8vi)
  p13v = float(packet_data_array[*].p13vi)

end

pro eis_sts2_reformatter::create_cam_psu_currents_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts2_reformatter::create_cam_psu_currents_bintable_extension'

  self->unpack_cam_psu_voltages, packet_data_array, p39v, p7v, n8v, p8v, p13v

  if self.padding then begin
     self->pad, p39v,  pntrs
     self->pad, p7v,   pntrs
     self->pad, n8v,   pntrs
     self->pad, p8v,   pntrs
     self->pad, p13v,  pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p39v, 'PSU_CAM_P39VI', 'PSU Supplied +39V Current', tunit='Amps', tdmin=min(p39v), tdmax=max(p39v)
  fxbaddcol, col, header, p7v,  'PSU_CAM_P7VI',  'PSU Supplied +7V Current',  tunit='Amps', tdmin=min(p7v),  tdmax=max(p7v)
  fxbaddcol, col, header, n8v,  'PSU_CAM_N8VI',  'PSU Supplied -8V Current',  tunit='Amps', tdmin=min(n8v),  tdmax=max(n8v)
  fxbaddcol, col, header, p8v,  'PSU_CAM_P8VI',  'PSU Supplied +8V Current',  tunit='Amps', tdmin=min(p8v),  tdmax=max(p8v)
  fxbaddcol, col, header, p13v, 'PSU_CAM_P13VI', 'PSU Supplied +13V Current', tunit='Amps', tdmin=min(p13v), tdmax=max(p13v)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p39v, 1,  1, 'PSU_CAM_P39VI'
  self->write_data, lu, p7v,  2,  1, 'PSU_CAM_P7VI'
  self->write_data, lu, n8v,  3,  1, 'PSU_CAM_N8VI'
  self->write_data, lu, p8v,  4,  1, 'PSU_CAM_P8VI'
  self->write_data, lu, p13v, 5,  1, 'PSU_CAM_P13VI'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
