
pro eis_sts2_reformatter::unpack_cam_temperatures, packet_data_array, p0, p1
  self->trace, 'eis_sts2_reformatter::unpack_cam_temperatures'

  p0 = float(packet_data_array[*].upt)
  p1 = float(packet_data_array[*].lot)

end

pro eis_sts2_reformatter::create_cam_temperatures_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts2_reformatter::create_cam_temperatures_bintable_extension'

  self->unpack_cam_temperatures, packet_data_array, p0, p1

  if self.padding then begin
     self->pad, p0, pntrs
     self->pad, p1, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p0,  'CAM_UP_TEMP', 'Camera upper temperature', tunit='Degree C', tdmin=min(p0),  tdmax=max(p0)
  fxbaddcol, col, header, p1,  'CAM_LO_TEMP', 'Camera lower temperature', tunit='Degree C', tdmin=min(p1),  tdmax=max(p1)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p0, 1,  1, 'CAM_UP_TEMP'
  self->write_data, lu, p1, 2,  1, 'CAM_LO_TEMP'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
