
pro eis_sts2_reformatter::create_spacecraft_bintable_extension, header, packet_data_array
	self->trace, 'eis_sts2_reformatter::create_spacecraft_bintable_extension'

  self->unpack_spacecraft_parameters, packet_data_array, apid, scount, plength, sc_time

  ; Create the column descriptions
  fxbaddcol, col, header, sc_time, 'Time',             'None', tunit='None', tdmin=min(sc_time), tdmax=max(sc_time)
  fxbaddcol, col, header, scount,  'Sequence Counter', 'None', tunit='None', tdmin=min(scount),  tdmax=max(scount)

  ; Create the fits header
  self->create_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, sc_time, 1, 1, 'TIME'
  self->write_data, lu, scount,  2, 1, 'SEQ_COUNTER'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
