
pro eis_sts2_reformatter::prepare_primary_header_parameters, file, packet_array
  self->trace, 'eis_sts2_reformatter::prepare_primary_header_parameters'

  ; Unpack ccsds headers now to get info for primary header
  self->unpack_ccsds_header, packet_array, apid, scount, plength, stime
  help, apid
  ; File will have a filename:
  ;     eis_sts_yyyymmdd_hhmmssttmm
  ; and will create a fits file with name:
  ;     eis_sts1_yyymmdd_hhmmss.fits
  ; for a status 1 archive
  ; hk1, hk2, hk3, sts1, sts2, sts3

  ; Do spacecraft time conversions here to send to add_primary_header
  ; Get the first scpacecraft time (ti)
  sc_time_start = stime[0]
  sc_time_end = stime[self.number_of_received_packets - 1]
  ; Create the fits file filename
  break_file, file, disk_log, dir, filename, ext, fversion, node
  yr_str = strmid(filename, 8, 8)
  hr_str = strmid(filename, 17, 6)
  grt = yr_str + hr_str

  ;;;;    ut_str = eis_ti2utc(string(sc_time), grt)
  ;ut_str = self->eis_ti2utc(sc_time_start, grt)
  ;;;;    ut_end   = eis_ti2utc(string(sc_time_end), yr_str + hr_str)
  ;ut_end  = self->eis_ti2utc(sc_time_end, yr_str + hr_str)
  ;converted_ok = strpos(ut_str, 'T', 8)

  ut_str = yr_str + '_' + hr_str ;'20161012T123456.000'
  ut_end = yr_str + '_' + hr_str ; '20151012T234510.000'
  converted_ok = 1

  if converted_ok ne -1 then begin ; Good conversion
    new_ut_str = ut_str
    ;;;        strput,ut_str,'_',8
    strput,new_ut_str,'_',8
    ; Make fits file name from ut string
    fitsFile = self.fits_base + '/' + 'eis_' + self.status_type + '_' + new_ut_str + '.fits'
    ; More processing for header (convered ok etc)
    ti_conv = 1
  endif else begin
    ; Make fits file name from grt string
    fitsFile = self.fits_base + '/' + 'eis_' + self.status_type + '_' + yr_str + '_' + hr_str + '.fits'
    ; More processing for header, bad case
    ti_conv = 0
  endelse
  self.grt           = grt
  self.sc_start      = sc_time_start
  self.sc_end        = sc_time_end
  self.ut_start      = ut_str
  self.ut_end        = ut_end
  self.ti_conv       = ti_conv
  self.fits_filename = fitsFile

end
