
pro eis_sts3_reformatter::create_bintable_extension, extension_name, extension_comment, packet_data_array, pntrs
  self->trace, 'eis_sts3_reformatter::create_bintable_extension'

  if self->create_bintable_extension_header(extension_name, extension_comment, header) then begin

     self->add_primary_header_keywords, header

     case extension_name of
        'MHC REFERENCES'       : self->create_mhc_references_bintable_extension,       header, packet_data_array, pntrs
        'MHC VOLTAGES'         : self->create_mhc_voltages_bintable_extension,         header, packet_data_array, pntrs
        'MHC CURRENTS'         : self->create_mhc_currents_bintable_extension,         header, packet_data_array, pntrs
        'MHC GP0 TEMPERATURES' : self->create_mhc_gp0_temperatures_bintable_extension, header, packet_data_array, pntrs
        'MHC GP2 TEMPERATURES' : self->create_mhc_gp2_temperatures_bintable_extension, header, packet_data_array, pntrs
        'MHC MECHANISMS'       : self->create_mhc_mechanisms_bintable_extension,       header, packet_data_array, pntrs
        'MHC STATUS'           : self->create_mhc_status_bintable_extension,           header, packet_data_array, pntrs
        'MHC COUNTERS'         : self->create_mhc_counters_bintable_extension,         header, packet_data_array, pntrs
        'MHC QCM'              : self->create_mhc_qcm_bintable_extension,              header, packet_data_array, pntrs
        'MHC SUBCOM TABLE'     : self->create_mhc_subcom_bintable_extension,           header, packet_data_array, pntrs
        'SPACECRAFT'           : self->create_spacecraft_bintable_extension,           header, packet_data_array, pntrs
        else                   : self->log, 'Unknown extension name: ' + extension_name
     endcase
     
  endif
  
end
