
pro eis_sts3_reformatter::unpack_mhc_counters, packet_data_array, expt1, expt2, rec, ack, nack, cmd_id, time_msw, time_lsw
  self->trace, 'eis_sts3_reformatter::unpack_mhc_counters'

  ;; p2v5 = self->pad_data(packet_data_array.p2v5)
  expt1    = float(packet_data_array[*].expt1)
  expt2    = float(packet_data_array[*].expt2)
  rec      = float(packet_data_array[*].rec)
  ack      = float(packet_data_array[*].ack)
  nack     = float(packet_data_array[*].nack)
  cmd_id   = float(packet_data_array[*].cmd_id)
  time_msw = float(packet_data_array[*].time_msw)
  time_lsw = float(packet_data_array[*].time_lsw)

end

pro eis_sts3_reformatter::create_mhc_counters_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts3_reformatter::create_mhc_counters_bintable_extension'

  self->unpack_mhc_counters, packet_data_array, expt1, expt2, rec, ack, nack, cmd_id, time_msw, time_lsw

  if self.padding then begin
     self->pad, expt1,    pntrs
     self->pad, expt2,    pntrs
     self->pad, rec,      pntrs
     self->pad, ack,      pntrs
     self->pad, nack,     pntrs
     self->pad, cmd_id,   pntrs
     self->pad, time_msw, pntrs
     self->pad, time_lsw, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, expt1,    'MHC_EXP_T1',   'Shutter Open Time (53)',                   tunit='Msec',     tdmin=min(expt1),    tdmax=max(expt1)
  fxbaddcol, col, header, expt2,    'MHC_EXP_T2',   'Shutter Close Time (54)',                  tunit='Msec',     tdmin=min(expt2),    tdmax=max(expt2)
  fxbaddcol, col, header, rec,      'MHC_CMD_REC',  'MHC Command Counter (64)',                 tunit='Commands', tdmin=min(rec),      tdmax=max(rec)
  fxbaddcol, col, header, ack,      'MHC_CMD_ACK',  'MHC Command Acknowledge Counter (65)',     tunit='Commands', tdmin=min(ack),      tdmax=max(ack)
  fxbaddcol, col, header, nack,     'MHC_CMD_NACK', 'MHC Command Not Acknowledge Counter (66)', tunit='Commands', tdmin=min(nack),     tdmax=max(nack)
  fxbaddcol, col, header, cmd_id,   'MHC_CMD_ID',   'Last MHC Command Id Received (67)',        tunit='None',     tdmin=min(cmd_id),   tdmax=max(cmd_id)
  fxbaddcol, col, header, time_msw, 'MHC_TIME_MSW', 'MSW Elapsed Time Since Reset (70)',        tunit='Msec',     tdmin=min(time_msw), tdmax=max(time_msw)
  fxbaddcol, col, header, time_lsw, 'MHC_TIME_LSW', 'LSW Elapsed Time Since Reset (71)',        tunit='Msec',     tdmin=min(time_lsw), tdmax=max(time_lsw)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, expt1,    1, 1, 'MHC_EXP_T1'
  self->write_data, lu, expt2,    2, 1, 'MHC_EXP_T2'
  self->write_data, lu, rec,      3, 1, 'MHC_CMD_REC'
  self->write_data, lu, ack,      4, 1, 'MHC_CMD_ACK'
  self->write_data, lu, nack,     5, 1, 'MHC_CMD_NACK'
  self->write_data, lu, cmd_id,   6, 1, 'MHC_CMD_ID'
  self->write_data, lu, time_msw, 7, 1, 'MHC_TIME_MSW'
  self->write_data, lu, time_lsw, 8, 1, 'MHC_TIME_LSW'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
