
pro eis_sts3_reformatter::unpack_mhc_currents, packet_data_array, p5vdi, p15vai, n15vai, rdci
  self->trace, 'eis_sts3_reformatter::unpack_mhc_currents'

  ;; p2v5 = self->pad_data(packet_data_array.p2v5)
  p5vdi   = float(packet_data_array[*].p5vdi)
  p15vai  = float(packet_data_array[*].p15vai)
  n15vai  = float(packet_data_array[*].n15vai)
  rdci    = float(packet_data_array[*].rdci)

end

pro eis_sts3_reformatter::create_mhc_currents_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts3_reformatter::create_mhc_currents_bintable_extension'

  self->unpack_mhc_currents, packet_data_array, p5vdi, p15vai, n15vai, rdci

  if self.padding then begin
     self->pad, p5vdi,  pntrs
     self->pad, p15vai, pntrs
     self->pad, n15vai, pntrs
     self->pad, rdci,   pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, p5vdi,  'MHC_P5V_DI',  '+5 Digital Current (10)', tunit='Amps', tdmin=min(p5vdi),  tdmax=max(p5vdi)
  fxbaddcol, col, header, p15vai, 'MHC_P15V_AI', '+15 Analog Current (11)', tunit='Amps', tdmin=min(p15vai), tdmax=max(p15vai)
  fxbaddcol, col, header, n15vai, 'MHC_N15V_AI', '-15 Analog Current (12)', tunit='Amps', tdmin=min(n15vai), tdmax=max(n15vai)
  fxbaddcol, col, header, rdci,   'MHC_RDC_I',   'RDC Current (15)',        tunit='Amps', tdmin=min(rdci),   tdmax=max(rdci)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, p5vdi,  1, 1, 'MHC_P5V_DI'
  self->write_data, lu, p15vai, 2, 1, 'MHC_P15V_AI'
  self->write_data, lu, n15vai, 3, 1, 'MHC_N15V_AI'
  self->write_data, lu, rdci,   4, 1, 'MHC_RDC_I'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
