
pro eis_sts3_reformatter::unpack_mhc_gp0_temperatures, packet_data_array, t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12
  self->trace, 'eis_sts3_reformatter::unpack_mhc_gp0_temperatures'

  ;; p2v5 = self->pad_data(packet_data_array.p2v5)
  t0  = float(packet_data_array[*].t0)
  t1  = float(packet_data_array[*].t1)
  t2  = float(packet_data_array[*].t2)
  t3  = float(packet_data_array[*].t3)
  t4  = float(packet_data_array[*].t4)
  t5  = float(packet_data_array[*].t5)
  t6  = float(packet_data_array[*].t6)
  t7  = float(packet_data_array[*].t7)
  t8  = float(packet_data_array[*].t8)
  t9  = float(packet_data_array[*].t9)
  t10 = float(packet_data_array[*].t10)
  t11 = float(packet_data_array[*].t11)
  t12 = float(packet_data_array[*].t12)

end

pro eis_sts3_reformatter::create_mhc_gp0_temperatures_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts3_reformatter::create_mhc_gp0_temperatures_bintable_extension'

  self->unpack_mhc_gp0_temperatures, packet_data_array, t0, t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12

  if self.padding then begin
     self->pad, t0,  pntrs
     self->pad, t1,  pntrs
     self->pad, t2,  pntrs
     self->pad, t3,  pntrs
     self->pad, t4,  pntrs
     self->pad, t5,  pntrs
     self->pad, t6,  pntrs
     self->pad, t7,  pntrs
     self->pad, t8,  pntrs
     self->pad, t9,  pntrs
     self->pad, t10, pntrs
     self->pad, t11, pntrs
     self->pad, t12, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, t0,  'MHC_DB_T0',         'Digital Board (16)',                      tunit='Degrees C', tdmin=min(t0),  tdmax=max(t0)
  fxbaddcol, col, header, t1,  'MHC_BOX_T1',        'Box temperature (17)',                    tunit='Degrees C', tdmin=min(t1),  tdmax=max(t1)
  fxbaddcol, col, header, t2,  'MHC_PB_T2',         'Power Board Conv B FET (18)',             tunit='Degrees C', tdmin=min(t2),  tdmax=max(t2)
  fxbaddcol, col, header, t3,  'MHC_PB_T3',         'Power Board Conv A FET (19)',             tunit='Degrees C', tdmin=min(t3),  tdmax=max(t3)
  fxbaddcol, col, header, t4,  'MHC_SLA_T4',        'Slit Slot Motor Temperature (20)',        tunit='Degrees C', tdmin=min(t4),  tdmax=max(t4)
  fxbaddcol, col, header, t5,  'MHC_SLA_T5',        'Shutter Motor Temperature (21)',          tunit='Degrees C', tdmin=min(t5),  tdmax=max(t5)
  fxbaddcol, col, header, t6,  'MHC_HARNESS_T6',    'Harness Temperature (22)',                tunit='Degrees C', tdmin=min(t6),  tdmax=max(t6)
  fxbaddcol, col, header, t7,  'MHC_MIR_BASE_T7',   'Mirror Assembly Base Temperature (23)',   tunit='Degrees C', tdmin=min(t7),  tdmax=max(t7)
  fxbaddcol, col, header, t8,  'MHC_MIR_PZT_T8',    'Mirror Assembly PZT Temperature (24)',    tunit='Degrees C', tdmin=min(t8),  tdmax=max(t8)
  fxbaddcol, col, header, t9,  'MHC_MIR_MOTOR_T9',  'Mirror Assembly Motor Temperature (25)',  tunit='Degrees C', tdmin=min(t9),  tdmax=max(t9)
  fxbaddcol, col, header, t10, 'MHC_GRA_MOTOR_T10', 'Grating Assembly Motor Temperature (26)', tunit='Degrees C', tdmin=min(t10), tdmax=max(t10)
  fxbaddcol, col, header, t11, 'MHC_GRA_ASM_T11',   'Grating Assembly Temperature (27)',       tunit='Degrees C', tdmin=min(t11), tdmax=max(t11)
  fxbaddcol, col, header, t12, 'MHC_PB_D4_T12',     'Power Board +5VM Rectifier D4 (28)',      tunit='Degrees C', tdmin=min(t12), tdmax=max(t12)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, t0,   1, 1, 'MHC_DB_T0'
  self->write_data, lu, t1,   2, 1, 'MHC_BOX_T1'
  self->write_data, lu, t2,   3, 1, 'MHC_PB_T2'
  self->write_data, lu, t3,   4, 1, 'MHC_PB_T3'
  self->write_data, lu, t4,   5, 1, 'MHC_SLA_T4'
  self->write_data, lu, t5,   6, 1, 'MHC_SLA_T5'
  self->write_data, lu, t6,   7, 1, 'MHC_HARNESS_T6'
  self->write_data, lu, t7,   8, 1, 'MHC_MIR_BASE_T7'
  self->write_data, lu, t8,   9, 1, 'MHC_MIR_PZT_T8'
  self->write_data, lu, t9,  10, 1, 'MHC_MIR_MOTOR_T9'
  self->write_data, lu, t10, 11, 1, 'MHC_GRA_MOTOR_T10'
  self->write_data, lu, t11, 12, 1, 'MHC_GRA_ASM_T11'
  self->write_data, lu, t12, 13, 1, 'MHC_PB_D4_T12'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
