
pro eis_sts3_reformatter::unpack_mhc_gp2_temperatures, packet_data_array, hzt0, hzt1, hzt2, hzt3, hzt4, hzt5, hzt6, hzt7, hzt8, hzt9, hzt10, hzt11, hzt12, hzt13, hzt14, hzt15
  self->trace, 'eis_sts3_reformatter::unpack_mhc_gp2_temperatures'

  ;; p2v5 = self->pad_data(packet_data_array.p2v5)
  hzt0  = float(packet_data_array[*].hzt0)
  hzt1  = float(packet_data_array[*].hzt1)
  hzt2  = float(packet_data_array[*].hzt2)
  hzt3  = float(packet_data_array[*].hzt3)
  hzt4  = float(packet_data_array[*].hzt4)
  hzt5  = float(packet_data_array[*].hzt5)
  hzt6  = float(packet_data_array[*].hzt6)
  hzt7  = float(packet_data_array[*].hzt7)
  hzt8  = float(packet_data_array[*].hzt8)
  hzt9  = float(packet_data_array[*].hzt9)
  hzt10 = float(packet_data_array[*].hzt10)
  hzt11 = float(packet_data_array[*].hzt11)
  hzt12 = float(packet_data_array[*].hzt12)
  hzt13 = float(packet_data_array[*].hzt13)
  hzt14 = float(packet_data_array[*].hzt14)
  hzt15 = float(packet_data_array[*].hzt15)

end

pro eis_sts3_reformatter::create_mhc_gp2_temperatures_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts3_reformatter::create_mhc_gp2_temperatures_bintable_extension'

  self->unpack_mhc_gp2_temperatures, packet_data_array, hzt0, hzt1, hzt2, hzt3, hzt4, hzt5, hzt6, hzt7, hzt8, hzt9, hzt10, hzt11, hzt12, hzt13, hzt14, hzt15

  if self.padding then begin
     self->pad, hzt0,  pntrs
     self->pad, hzt1,  pntrs
     self->pad, hzt2,  pntrs
     self->pad, hzt3,  pntrs
     self->pad, hzt4,  pntrs
     self->pad, hzt5,  pntrs
     self->pad, hzt6,  pntrs
     self->pad, hzt7,  pntrs
     self->pad, hzt8,  pntrs
     self->pad, hzt9,  pntrs
     self->pad, hzt10, pntrs
     self->pad, hzt11, pntrs
     self->pad, hzt12, pntrs
     self->pad, hzt13, pntrs
     self->pad, hzt14, pntrs
     self->pad, hzt15, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, hzt0,  'MHC_HZ_T0',  'Heater Zone 2 (31)', tunit='Degrees C', tdmin=min(hzt0),  tdmax=max(hzt0)
  fxbaddcol, col, header, hzt1,  'MHC_HZ_T1',  'Heater Zone 2 (32)', tunit='Degrees C', tdmin=min(hzt1),  tdmax=max(hzt1)
  fxbaddcol, col, header, hzt2,  'MHC_HZ_T2',  'Heater Zone 2 (33)', tunit='Degrees C', tdmin=min(hzt2),  tdmax=max(hzt2)
  fxbaddcol, col, header, hzt3,  'MHC_HZ_T3',  'Heater Zone 2 (34)', tunit='Degrees C', tdmin=min(hzt3),  tdmax=max(hzt3)
  fxbaddcol, col, header, hzt4,  'MHC_HZ_T4',  'Heater Zone 2 (35)', tunit='Degrees C', tdmin=min(hzt4),  tdmax=max(hzt4)
  fxbaddcol, col, header, hzt5,  'MHC_HZ_T5',  'Heater Zone 2 (36)', tunit='Degrees C', tdmin=min(hzt5),  tdmax=max(hzt5)
  fxbaddcol, col, header, hzt6,  'MHC_HZ_T6',  'Heater Zone 2 (37)', tunit='Degrees C', tdmin=min(hzt6),  tdmax=max(hzt6)
  fxbaddcol, col, header, hzt7,  'MHC_HZ_T7',  'Heater Zone 2 (38)', tunit='Degrees C', tdmin=min(hzt7),  tdmax=max(hzt7)
  fxbaddcol, col, header, hzt8,  'MHC_HZ_T8',  'Heater Zone 2 (39)', tunit='Degrees C', tdmin=min(hzt8),  tdmax=max(hzt8)
  fxbaddcol, col, header, hzt9,  'MHC_HZ_T9',  'Heater Zone 2 (40)', tunit='Degrees C', tdmin=min(hzt9),  tdmax=max(hzt9)
  fxbaddcol, col, header, hzt10, 'MHC_HZ_T10', 'Heater Zone 2 (41)', tunit='Degrees C', tdmin=min(hzt10), tdmax=max(hzt10)
  fxbaddcol, col, header, hzt11, 'MHC_HZ_T11', 'Heater Zone 2 (42)', tunit='Degrees C', tdmin=min(hzt11), tdmax=max(hzt11)
  fxbaddcol, col, header, hzt12, 'MHC_HZ_T12', 'Heater Zone 2 (43)', tunit='Degrees C', tdmin=min(hzt12), tdmax=max(hzt12)
  fxbaddcol, col, header, hzt13, 'MHC_HZ_T13', 'Heater Zone 2 (44)', tunit='Degrees C', tdmin=min(hzt13), tdmax=max(hzt13)
  fxbaddcol, col, header, hzt14, 'MHC_HZ_T14', 'Heater Zone 2 (45)', tunit='Degrees C', tdmin=min(hzt14), tdmax=max(hzt14)
  fxbaddcol, col, header, hzt15, 'MHC_HZ_T15', 'Heater Zone 2 (46)', tunit='Degrees C', tdmin=min(hzt15), tdmax=max(hzt15)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, hzt0,   1, 1, 'MHC_HZ_T0'
  self->write_data, lu, hzt1,   2, 1, 'MHC_HZ_T1'
  self->write_data, lu, hzt2,   3, 1, 'MHC_HZ_T2'
  self->write_data, lu, hzt3,   4, 1, 'MHC_HZ_T3'
  self->write_data, lu, hzt4,   5, 1, 'MHC_HZ_T4'
  self->write_data, lu, hzt5,   6, 1, 'MHC_HZ_T5'
  self->write_data, lu, hzt6,   7, 1, 'MHC_HZ_T6'
  self->write_data, lu, hzt7,   8, 1, 'MHC_HZ_T7'
  self->write_data, lu, hzt8,   9, 1, 'MHC_HZ_T8'
  self->write_data, lu, hzt9,  10, 1, 'MHC_HZ_T9'
  self->write_data, lu, hzt10, 11, 1, 'MHC_HZ_T10'
  self->write_data, lu, hzt11, 12, 1, 'MHC_HZ_T11'
  self->write_data, lu, hzt12, 13, 1, 'MHC_HZ_T12'
  self->write_data, lu, hzt13, 14, 1, 'MHC_HZ_T13'
  self->write_data, lu, hzt14, 15, 1, 'MHC_HZ_T14'
  self->write_data, lu, hzt15, 16, 1, 'MHC_HZ_T15'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
