
pro eis_sts3_reformatter::unpack_mhc_mechanisms, packet_data_array, grapos, ss_step, cmir_steps, cmirpos, sspos, gra_sw
  self->trace, 'eis_sts3_reformatter::unpack_mhc_mechanisms'

  ;; p2v5 = self->pad_data(packet_data_array.p2v5)
  grapos     = float(packet_data_array[*].grapos)
  ss_step    = float(packet_data_array[*].ss_step)
  cmir_steps = float(packet_data_array[*].cmir_steps)
  cmirpos    = float(packet_data_array[*].cmirpos)
  sspos      = float(packet_data_array[*].sspos)
  gra_sw     = float(packet_data_array[*].gra_sw)

end

pro eis_sts3_reformatter::create_mhc_mechanisms_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts3_reformatter::create_mhc_mechanisms_bintable_extension'

  self->unpack_mhc_mechanisms, packet_data_array, grapos, ss_step, cmir_steps, cmirpos, sspos, gra_sw

  if self.padding then begin
     self->pad, grapos,     pntrs
     self->pad, ss_step,    pntrs
     self->pad, cmir_steps, pntrs
     self->pad, cmirpos,    pntrs
     self->pad, sspos,      pntrs
     self->pad, gra_sw,     pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, grapos,     'MHC_GRA_POS_AN',     'MHC Grating Analog Position (6)',         tunit='None', tdmin=min(grapos),     tdmax=max(grapos)
  fxbaddcol, col, header, ss_step,    'MHC_SS_POS_STEPS',   'MHC SS Motor Positions (7)',              tunit='None', tdmin=min(ss_step),    tdmax=max(ss_step)
  fxbaddcol, col, header, cmir_steps, 'MHC_CMIR_POS_STEPS', 'MHC CMIR Positions (13)',                 tunit='None', tdmin=min(cmir_steps), tdmax=max(cmir_steps)
  fxbaddcol, col, header, cmirpos,    'MHC_CMIR_POS',       'RDC Derived Primary Mirror Postion (48)', tunit='None', tdmin=min(cmirpos),    tdmax=max(cmirpos)
  fxbaddcol, col, header, sspos,      'MHC_SS_POS',         'RDC Derived Slit/Slot Position (49)',     tunit='None', tdmin=min(sspos),      tdmax=max(sspos)
  fxbaddcol, col, header, gra_sw,     'MHC_GRA_SW_POS',     'Software Tracked GRA Position (52)',      tunit='None', tdmin=min(gra_sw),     tdmax=max(gra_sw)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, grapos,     1, 1, 'MHC_GRA_POS_AN'
  self->write_data, lu, ss_step,    2, 1, 'MHC_SS_POS_STEPS'
  self->write_data, lu, cmir_steps, 3, 1, 'MHC_CMIR_POS_STEPS'
  self->write_data, lu, cmirpos,    4, 1, 'MHC_CMIR_POS'
  self->write_data, lu, sspos,      5, 1, 'MHC_SS_POS'
  self->write_data, lu, gra_sw,     6, 1, 'MHC_GRA_SW_POS'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
