
pro eis_sts3_reformatter::unpack_mhc_qcm, packet_data_array, qcm_msw, qcm_lsw, qct1, qct2, qcm_clk
  self->trace, 'eis_sts3_reformatter::unpack_mhc_qcm'

  ;; p2v5 = self->pad_data(packet_data_array.p2v5)
  qcm_msw = float(packet_data_array[*].qcm_msw)
  qcm_lsw = float(packet_data_array[*].qcm_lsw)
  qct1    = float(packet_data_array[*].qct1)
  qct2    = float(packet_data_array[*].qct2)
  qcm_clk = float(packet_data_array[*].qcm_clk)

end

pro eis_sts3_reformatter::create_mhc_qcm_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts3_reformatter::create_mhc_qcm_bintable_extension'

  self->unpack_mhc_qcm, packet_data_array, qcm_msw, qcm_lsw, qct1, qct2, qcm_clk

  if self.padding then begin
     self->pad, qcm_msw, pntrs
     self->pad, qcm_lsw, pntrs
     self->pad, qct1,    pntrs
     self->pad, qct2,    pntrs
     self->pad, qcm_clk, pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, qcm_msw, 'MHC_QCM_MSW',       'Last Enabled QCM Integration Count MSW (59)', tunit='None', tdmin=min(qcm_msw), tdmax=max(qcm_msw)
  fxbaddcol, col, header, qcm_lsw, 'MHC_QCM_LSW',       'Last Enabled QCM Integration Count LSW (60)', tunit='None', tdmin=min(qcm_lsw), tdmax=max(qcm_lsw)
  fxbaddcol, col, header, qct1,    'MHC_QCM1_TEMP',     'Contamination Monitor 1 Temperature (61)',    tunit='None', tdmin=min(qct1),    tdmax=max(qct1)
  fxbaddcol, col, header, qct2,    'MHC_QCM2_TEMP',     'Contamination Monitor 2 Temperature (62)',    tunit='None', tdmin=min(qct2),    tdmax=max(qct2)
  fxbaddcol, col, header, qcm_clk, 'MHC_QCM_INT_CLOCK', 'Last Enabled QCM Integration Time (63)',      tunit='None', tdmin=min(qcm_clk), tdmax=max(qcm_clk)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, qcm_msw, 1, 1, 'MHC_QCM_MSW'
  self->write_data, lu, qcm_lsw, 2, 1, 'MHC_QCM_LSW'
  self->write_data, lu, qct1,    3, 1, 'MHC_QCM1_TEMP'
  self->write_data, lu, qct2,    4, 1, 'MHC_QCM2_TEMP'
  self->write_data, lu, qcm_clk, 5, 1, 'MHC_QCM_INT_CLOCK'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
