
pro eis_sts3_reformatter::unpack_mhc_references, packet_data_array, sgv_ref, gndiref, ref, cal, gndref
  self->trace, 'eis_sts3_reformatter::unpack_mhc_references'

  ;; p2v5 = self->pad_data(packet_data_array.p2v5)
  sgv_ref = float(packet_data_array[*].sgv_ref)
  gndiref = float(packet_data_array[*].gndiref)
  ref     = float(packet_data_array[*].ref)
  cal     = float(packet_data_array[*].cal)
  gndref  = float(packet_data_array[*].gndref)

end

pro eis_sts3_reformatter::create_mhc_references_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts3_reformatter::create_mhc_references_bintable_extension'

  self->unpack_mhc_references, packet_data_array, sgv_ref, gndiref, ref, cal, gndref

  if self.padding then begin
     self->pad, sgv_ref, pntrs
     self->pad, gndiref, pntrs
     self->pad, ref,     pntrs
     self->pad, cal,     pntrs
     self->pad, gndref,  pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, sgv_ref, 'MHC_SGV_REF',    'Strain Gauge Reference Voltage (9)',      tunit='None', tdmin=min(sgv_ref), tdmax=max(sgv_ref)
  fxbaddcol, col, header, gndiref, 'MHC_GND_I_REF',  'MHC Current Input Ground Reference (14)', tunit='None', tdmin=min(gndiref), tdmax=max(gndiref)
  fxbaddcol, col, header, ref,     'MHC_REF_THER_0', 'Thermistor zero reference (29)',          tunit='None', tdmin=min(ref),     tdmax=max(ref)
  fxbaddcol, col, header, cal,     'MHC_CAL_THER_0', 'Thermistor calibration resistor (30)',    tunit='None', tdmin=min(cal),     tdmax=max(cal)
  fxbaddcol, col, header, gndref,  'MHC_GND_F_REF',  'MHC Zero Reference (47)',                 tunit='None', tdmin=min(gndref),  tdmax=max(gndref)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, sgv_ref, 1, 1, 'MHC_SGV_REF'
  self->write_data, lu, gndiref, 2, 1, 'MHC_GND_I_REF'
  self->write_data, lu, ref,     3, 1, 'MHC_REF_THER_0'
  self->write_data, lu, cal,     4, 1, 'MHC_CAL_THER_0'
  self->write_data, lu, gndref,  5, 1, 'MHC_GND_F_REF'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
