
pro eis_sts3_reformatter::unpack_mhc_status, packet_data_array, mtr_opt_enc, act_opt_enc, act_stat, cal_src, htr_stat, sec_msw, sec_lsw, sys_stat
  self->trace, 'eis_sts3_reformatter::unpack_mhc_status'

  ;; p2v5 = self->pad_data(packet_data_array.p2v5)
  mtr_opt_enc = float(packet_data_array[*].mtr_opt_enc)
  act_opt_enc = float(packet_data_array[*].act_opt_enc)
  act_stat    = float(packet_data_array[*].act_stat)
  cal_src     = float(packet_data_array[*].cal_src)
  htr_stat    = float(packet_data_array[*].htr_stat)
  sec_msw     = float(packet_data_array[*].sec_msw) ; ???????????
  sec_lsw     = float(packet_data_array[*].sec_lsw) ; ???????????
  sys_stat    = float(packet_data_array[*].sys_stat)
end

pro eis_sts3_reformatter::create_mhc_status_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts3_reformatter::create_mhc_status_bintable_extension'

  self->unpack_mhc_status, packet_data_array, mtr_opt_enc, act_opt_enc, act_stat, cal_src, htr_stat, sec_msw, sec_lsw, sys_stat

  if self.padding then begin
     self->pad, mtr_opt_enc, pntrs
     self->pad, act_opt_enc, pntrs
     self->pad, act_stat,    pntrs
     self->pad, cal_src,     pntrs
     self->pad, htr_stat,    pntrs
     self->pad, sec_msw,     pntrs
     self->pad, sec_lsw,     pntrs
     self->pad, sys_stat,    pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, mtr_opt_enc, 'MHC_MOTOR_OPT_ENC', 'Optical Encoders Status (50)',     tunit='None', tdmin=min(mtr_opt_enc), tdmax=max(mtr_opt_enc)
  fxbaddcol, col, header, act_opt_enc, 'MHC_ACT_OPT_ENC',   'Actuator Encodings (51)',          tunit='None', tdmin=min(act_opt_enc), tdmax=max(act_opt_enc)
  fxbaddcol, col, header, act_stat,    'MHC_ACT_STAT',      'State of each Actuator (56)',      tunit='None', tdmin=min(act_stat),    tdmax=max(act_stat)
  fxbaddcol, col, header, cal_src,     'MHC_CAL_SRC_STAT',  'CAL LED Source State (57)',        tunit='None', tdmin=min(cal_src),     tdmax=max(cal_src)
  fxbaddcol, col, header, htr_stat,    'MHC_HTR_STAT',      'Status of MHC Heaters (58)',       tunit='None', tdmin=min(htr_stat),    tdmax=max(htr_stat)
  fxbaddcol, col, header, sec_msw,     'MHC_SEQ_MSW',       'MHC Internal Error Code MSW (68)', tunit='None', tdmin=min(sec_msw),     tdmax=max(sec_msw)
  fxbaddcol, col, header, sec_lsw,     'MHC_SEQ_LSW',       'MHC Internal Error Code LSW (69)', tunit='None', tdmin=min(sec_lsw),     tdmax=max(sec_lsw)
  fxbaddcol, col, header, sys_stat,    'MHC_SYS_STAT',      'MHC System Status Code (72)',      tunit='None', tdmin=min(sys_stat),    tdmax=max(sys_stat)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, mtr_opt_enc, 1, 1, 'MHC_MOTOR_OPT_ENC'
  self->write_data, lu, act_opt_enc, 2, 1, 'MHC_ACT_OPT_ENC'
  self->write_data, lu, act_stat,    3, 1, 'MHC_ACT_STAT'
  self->write_data, lu, cal_src,     4, 1, 'MHC_CAL_SRC_STAT'
  self->write_data, lu, htr_stat,    5, 1, 'MHC_HTR_STAT'
  self->write_data, lu, sec_msw,     6, 1, 'MHC_SEQ_MSW'
  self->write_data, lu, sec_lsw,     7, 1, 'MHC_SEQ_LSW'
  self->write_data, lu, sys_stat,    8, 1, 'MHC_SYS_STAT'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
