; need to get bakeout heater controller status

pro eis_sts3_reformatter::unpack_mhc_voltages, packet_data_array, sgop, p5vd, p15va, n15va, p15vm, p120_pzt, pzt_drv, vac
  self->trace, 'eis_sts3_reformatter::unpack_mhc_voltages'

  ;; p2v5 = self->pad_data(packet_data_array.p2v5)
  sgop     = float(packet_data_array[*].sgop)
  p5vd     = float(packet_data_array[*].p5vd)
  p15va    = float(packet_data_array[*].p15va)
  n15va    = float(packet_data_array[*].n15va)
  p15vm    = float(packet_data_array[*].p15vm)
  p120_pzt = float(packet_data_array[*].p120_pzt)
  pzt_drv  = float(packet_data_array[*].pzt_drv)
  vac      = float(packet_data_array[*].vac)
end

pro eis_sts3_reformatter::create_mhc_voltages_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_sts3_reformatter::create_mhc_voltages_bintable_extension'

  self->unpack_mhc_voltages, packet_data_array, sgop, p5vd, p15va, n15va, p15vm, p120_pzt, pzt_drv, vac

  if self.padding then begin
     self->pad, sgop,     pntrs
     self->pad, p5vd,     pntrs
     self->pad, p15va,    pntrs
     self->pad, n15va,    pntrs
     self->pad, p15vm,    pntrs
     self->pad, p120_pzt, pntrs
     self->pad, pzt_drv,  pntrs
     self->pad, vac,      pntrs
  endif

  ; Create the column descriptions
  fxbaddcol, col, header, sgop,     'MHC_SG_OP',     'PZT Strain Gauge Output (1)',     tunit='Volts', tdmin=min(sgop),     tdmax=max(sgop)
  fxbaddcol, col, header, p5vd,     'MHC_P5VD',      '+5 Volts Digital Supply (2)',     tunit='Volts', tdmin=min(p5vd),     tdmax=max(p5vd)
  fxbaddcol, col, header, p15va,    'MHC_P15V_A',    '+15 Analog Voltage (3)',          tunit='Volts', tdmin=min(p15va),    tdmax=max(p15va)
  fxbaddcol, col, header, n15va,    'MHC_N15V_A',    '-15 Analog Voltage (4)',          tunit='Volts', tdmin=min(n15va),    tdmax=max(n15va)
  fxbaddcol, col, header, p15vm,    'MHC_P15V_M',    '+15 DC Motor Voltage (5)',        tunit='Volts', tdmin=min(p15vm),    tdmax=max(p15vm)
  fxbaddcol, col, header, p120_pzt, 'MHC_P120V_PZT', '+120 PZT Voltage (8)',            tunit='Volts', tdmin=min(p120_pzt), tdmax=max(p120_pzt)
  fxbaddcol, col, header, pzt_drv,  'MHC_PZT_DRIVE', 'High Voltage Output to PZT (55)', tunit='Volts', tdmin=min(pzt_drv),  tdmax=max(pzt_drv)
  fxbaddcol, col, header, vac,      'MHC_VAC_GAUGE', 'Remote Vacuum Gauge (73)',        tunit='Volts', tdmin=min(vac),      tdmax=max(vac)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, sgop,     1, 1, 'MHC_SG_OP'
  self->write_data, lu, p5vd,     2, 1, 'MHC_P5VD'
  self->write_data, lu, p15va,    3, 1, 'MHC_P15V_A'
  self->write_data, lu, n15va,    4, 1, 'MHC_N15V_A'
  self->write_data, lu, p15vm,    5, 1, 'MHC_P15V_M'
  self->write_data, lu, p120_pzt, 6, 1, 'MHC_P120V_PZT'
  self->write_data, lu, pzt_drv,  7, 1, 'MHC_PZT_DRIVE'
  self->write_data, lu, vac,      8, 1, 'MHC_VAC_GAUGE'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
