
pro eis_sts3_reformatter::reformat_files
  self->trace, 'eis_sts3_reformatter::reformat_files'

  self->log, 'Looking for _sts3 files in ' + self.packet_source_directory
  files = FILE_SEARCH(self.packet_source_directory + '/' + '*_sts3', count=file_count)

  if file_count eq 0 then begin
    self->log, 'No files found for sts3'
    return
  endif else begin
    foreach file, files do begin
      self->log, 'Reading ' + file
      ;result = FILE_INFO(FILEPATH(file))
      result = FILE_INFO(file)
      self->log, 'result.size = ' + strtrim(string(result.size), 2)
      number_of_packets = result.size / self.packet_size
      self.number_of_received_packets = number_of_packets
      self->log, 'Expecting to read ' + strtrim(string(number_of_packets), 2) + ' packets'
      ; not necessary if using read_binary
      packet_array = replicate(self.sts3_data, number_of_packets)
      ;openr, lu, file, /get_lun
      ;on_ioerror, done
      ; replace with read_binary (and binary_template)
      packet_array = read_binary(file, DATA_DIMS = [number_of_packets, self.packet_size], ENDIAN = 'native')
      ;counter = 0L
      ;while counter le number_of_packets do begin
        ;readu, lu, packet
        ;packet_array[counter] = packet
        ;counter = counter + 1
      ;endwhile
  done:
      ;self->log, 'Found ' + strtrim(string(counter), 2) + ' packets'
      ;close, lu
      ;free_lun, lu
      self->log, 'Read file'
      ; Find out how much data is missing

      ; Get primary header data values
      self->prepare_primary_header_parameters, file, packet_array

      ; done in above method
      ;self->create_fits_file

      self->make_primary_header, header
      ; Make the primary header
      ;fxhmake, header, /initialize, /date, /extend

      ; Add primary header keywords
      self->add_primary_header_keywords, header, self.packet_interval_time

      ; Write the header to file
      fxwrite, self.fits_filename, header

      ; Create the binary table extensions
      self->create_sts3_extensions, packet_array

      self->debug

    endforeach

  endelse

end
