
pro eis_status_reformatter::add_primary_header_keywords, header
  self->trace, 'eis_status_reformatter::add_primary_header_keywords'

  fxaddpar, header, 'origin',   'ISAS',                 'Institute where file was written'
  fxaddpar, header, 'telescop', 'Hinode',               'Satellite name (Solar-B)'
  fxaddpar, header, 'instrume', 'EIS',                  'EUV Imaging Spectrometer'
  fxaddpar, header, 'program',  'eis_make_status_fits', 'Program used to generate the file'
  fxaddpar, header, 'version',  '1.0',                  'Program version'
  fxaddpar, header, 'release',  'Final Reformat',       'Confidence level'

  fxaddpar, header, 'gndtime', self.grt,                              'Archive ground receive time'
  fxaddpar, header, 'ti0',     string(self.sc_start, format='(Z08)'), 'Archive start time - Spacecraft time (TI)'
  fxaddpar, header, 'ti1',     string(self.sc_end, format='(Z08)'),   'Archive end time - Spacecraft time (TI)'

  ut_start1 = self->eis_convert_utc(self.ut_start)
  ut_end1   = self->eis_convert_utc(self.ut_end)

  fxaddpar, header, 'date_obs', ut_start1,                     'Archive start time (UT)'
  fxaddpar, header, 'date_end', ut_end1,                       'Archive end time (UT)'
  fxaddpar, header, 'ti_conv',  self.ti_conv eq 1 ? 'T' : 'F', 'Conversion to UT success'

  fxaddpar, header, 'interval', self.packet_interval_time,     'Packet frequencey (seconds)'

  fxaddpar, header, 'missing',  self.data_missing eq 1 ? 'T' : 'F', 'There are gaps in the data if T'
  fxaddpar, header, 'n_gaps',   self.n_gaps,                   'Number of gaps in the data'
  fxaddpar, header, 'n_sample', self.n_samples_missing,        'Number of samples missing from the data'

  if self.data_padded then $
    fxaddpar, header, 'padded',   'T',                         'Missing data filled with NaN' $
  else $
    fxaddpar, header, 'padded',   'F',                         'Data has not been padded with NaN'

end
