
pro eis_status_reformatter::create_spacecraft_bintable_extension, header, packet_data_array, pntrs
  self->trace, 'eis_status_reformatter::create_spacecraft_bintable_extension'

  self->unpack_ccsds_header, packet_data_array, apid, scount, plength, sc_time

  ; Create the column descriptions
  fxbaddcol, col, header, sc_time, 'TIME',        'Time',             tunit='None', tdmin=min(sc_time), tdmax=max(sc_time)
  fxbaddcol, col, header, scount,  'SEQ_COUNTER', 'Sequence Counter', tunit='None', tdmin=min(scount),  tdmax=max(scount)

  ; Create the fits header
  self->create_fits_header, lu, self.fits_filename, header

  ; Write the columns data
  self->write_data, lu, sc_time, 1, 1, 'TIME'
  self->write_data, lu, scount,  2, 1, 'SEQ_COUNTER'

  ; Finish up, close_fits_file disposes of lun
  self->close_fits_file, lu

end
