
pro eis_status_reformatter::debug
  self->trace, 'eis_status_reformatter::debug'
  
  self->log, 'status_type                : ' + self.status_type
  self->log, 'packet_size (bytes)        : ' + strtrim(string(self.packet_size), 2)
  self->log, 'packet_interval_time (s)   : ' + strtrim(string(self.packet_interval_time), 2)
  self->log, 'number_of_expected_packets : ' + strtrim(string(self.number_of_expected_packets), 2)
  self->log, 'number_of_received_packets : ' + strtrim(string(self.number_of_received_packets), 2)
  self->log, 'start_date                 : ' + self.start_date
  self->log, 'end_date                   : ' + self.end_date
  self->log, 'apid                       : ' + strtrim(string(self.apid), 2) + ' (' + strtrim(string(self.apid,format='(Z)'),2) + 'X)'
  self->log, 'packet_source_directory    : ' + self.packet_source_directory
  self->log, 'timing_directory           : ' + self.timing_directory
  self->log, 'timing_file                : ' + self.timing_file
  self->log, 'timing_files_directory     : ' + self.timing_files_directory
  self->log, 'packet_list_directory      : ' + self.packet_list_directory
  self->log, 'source_filename            : ' + self.source_filename
  self->log, 'fits_filename              : ' + self.fits_filename
  self->log, 'n_gaps                     : ' + strtrim(string(self.n_gaps), 2)
  if self.data_missing eq 1 then self->log, 'data_missing               : T' else self->log, 'data_missing               : F'
;	self->log, 'data_missing               : ' + (self.data_missing eq 1) ? 'T' : 'F'
  self->log, 'n_samples_missing          : ' + strtrim(string(self.n_samples_missing), 2)
  
end
