
; pro eis_status_reformatter::initialise
;   self->trace, 'eis_status_reformatter::initialise'
;   self.packet_source_directory = getenv('HOME') + '/work/localdata/sdtp/merge/split'
; end

;function eis_status_reformatter::Init
;;  self->trace, 'eis_status_reformatter::Init'
;  print, 'eis_status_reformatter::Init'
;  self.packet_list_directory = getenv('HOME') + '/work/localdata/sdtp/merge/split'
;  return, 1
;end

;pro eis_status_reformatter::debug
;  self->trace, 'eis_status_reformatter::debug'
;  
;  self->log, 'status_type                : ' + self.status_type
;  self->log, 'packet_size                : ' + strtrim(string(self.packet_size), 2)
;  self->log, 'packet_interval_time       : ' + strtrim(string(self.packet_interval_time), 2)
;  self->log, 'number_of_expected_packets : ' + strtrim(string(self.number_of_expected_packets), 2)
;  self->log, 'number_of_received_packets : ' + strtrim(string(self.number_of_received_packets), 2)
;  self->log, 'start_date                 : ' + self.start_date
;  self->log, 'end_date                   : ' + self.end_date
;  self->log, 'apid                       : ' + strtrim(string(self.apid), 2) + ' (' + strtrim(string(self.apid,format='(Z)'),2) + 'X)'
;  self->log, 'packet_source_directory    : ' + self.packet_source_directory
;  self->log, 'timing_directory           : ' + self.timing_directory
;  self->log, 'timing_files_directory     : ' + self.timing_files_directory
;  self->log, 'packet_list_directory      : ' + self.packet_list_directory
;  self->log, 'source_filename            : ' + self.source_filename
;  self->log, 'fits_filename              : ' + self.fits_filename
;  self->log, 'n_gaps                     : ' + strtrim(string(self.n_gaps), 2)
;  if self.data_missing eq 1 then self->log, 'data_missing               : T' else self->log, 'data_missing               : F'
;;	self->log, 'data_missing               : ' + (self.data_missing eq 1) ? 'T' : 'F'
;  self->log, 'n_samples_missing          : ' + strtrim(string(self.n_samples_missing), 2)
;  
;end

pro eis_status_reformatter__define
  
  struct = { eis_status_reformatter, $
             
             main_logger                : ptr_new(obj_new()), $
             logger                     : ptr_new(obj_new()), $
             
             archive_start_times	: ['0000', '0130', '0300', '0430', '0600', '0730', '0900', '1030', '1200', '1330', '1500', '1630', '1800', '1930', '2100', '2230'], $
             archive_elapsed_timings	: [0, 5400, 10800, 16200, 21600, 27000, 32400, 37800, 43200, 48600, 54000, 59400, 64800, 70200, 75600, 81000], $
             
             status_type		: '',        $ ; '_sts1' etc
             file_suffix                : '',        $
             packet_size		: 0,         $ ; 110 for stst1, 160 for sts2,3 etc
             status_acronym             : '',        $ ; STS1, HK1, etc

             packet_interval_time       : 0,         $ ; Packet interval time (= freq)
             number_of_expected_packets : 0L,        $
             number_of_received_packets : 0L,        $
             start_date                 : '',        $
             end_date                   : '',        $
             
             apid                       : 0,         $
             
             timing_directory		: '', $
             timing_files_directory	: '', $
             timing_file                : '',        $ ; needs to be added (in debug as well)
             packet_source_directory    : '',        $
             packet_list_directory      : '',        $
             source_filename            : '',        $
             fits_filename              : '',        $
             
             front			: 0,         $
             back			: 0,         $
             
             packet_data                : ptr_new(), $
             pad_data                   : ptr_new(), $
             interval                   : 0,         $
             grt                        : 0L,        $
             sc_start		        : 0L,        $
             sc_end                     : 0L,        $
             ut_start                   : '',        $
             ut_end                     : '',        $
             sts_type                   : '',        $
             hk_suffix                  : '',        $
             fits_base                  : '',        $
             fits_file                  : '',        $
             ti_conv                    : 0,         $
             fits_lun                   : 0,         $
             discontinuity              : ptr_new(), $
             gap_indices                : ptr_new(), $
             real_gaps                  : ptr_new(), $
             transfer_indices           : ptr_new(), $
             padding                    : 0,         $ ; Attempt to pad file
             data_padded                : 0,         $
             data_missing               : 0,         $
             n_samples_missing          : 0L,        $
             n_gaps                     : 0L,        $
             header                     : ptr_new(), $
             expected_n                 : 0L,        $

             inherits base_object }
  
end
