
pro eis_status_reformatter::read_data, file, packet_structure, packet_array
  self->trace, 'eis_status_reformatter::read_data'

  s = packet_structure
  packet_array = replicate(s, self.number_of_received_packets)
;;;  openr, lu, file, /get_lun
  openr, lu, file, /get_lun, /swap_if_little_endian
  on_ioerror, done
  count = 0L
  self->log, 'About to read ' + strtrim(string(self.number_of_received_packets),2) + ' packets'
  while count lt ulong(self.number_of_received_packets) do begin
    readu, lu, s
    packet_array[count] = s
    count = count + 1
  endwhile
  done:
  self->log, 'Read file. Found ' + strtrim(string(count), 2) + ' packets'
  close, lu
  free_lun, lu

end
