
pro eis_status_reformatter::reformat_files
  self->trace, 'eis_status_reformatter::reformat_files'

  ; Look for all 'sts1', then 'sts2', 'sts3' etc files
  self->log, 'Looking for ' + self.file_suffix + ' status files in ' + self.packet_source_directory
;  print, 'Looking for ' + self.file_suffix + ' status files in ' + self.packet_source_directory

  hk_files = FILE_SEARCH(self.packet_source_directory + '/' + '*' + self.file_suffix, count=file_count)

  if file_count eq 0 then begin
     self->log, 'No files found for ' + self.status_type
     return
  endif else begin
     self->log, 'Found ' + strtrim(string(file_count), 2) + ' ' + self.file_suffix + ' files'
     self->log, 'Looking for timing files for type ' + self.hk_suffix + ' in ' + self.timing_files_directory
;;;     timing_files = FILE_SEARCH(self.timing_files_directory + '/*' + self.hk_suffix + '.txt', count=timing_count)
     timing_files = FILE_SEARCH(self.timing_files_directory + '/' + self.hk_suffix + '*.log', count=timing_count)
;;;;     timing_files = FILE_SEARCH(self.timing_files_directory + '/' + self.hk_suffix + '.log', count=timing_count)
     
     if timing_count eq 0 then begin
        self->log, 'No timing files found for ' + self.hk_suffix
        self.padding = 0        ; Don't try to pad file
          ;return
     endif else begin
        self->log, 'Found ' + strtrim(string(timing_count),2) + ' files for type ' + self.hk_suffix
     endelse

     n_data_files = strtrim(string(file_count), 2)
     n_timing_files = strtrim(string(timing_count), 2)
     if file_count ne timing_count then begin
        self->log, 'Number of data files (' + n_data_files + ') does not match number of timing files (' + n_timing_files + ')'
        self->log, 'Padding not attempted'
        self.padding = 0
        ;;;;return
     endif

     self->log, ''

     ; For every status packet file...
     ;; timing_file_number = 0
     foreach file, hk_files do begin
        self.source_filename = file
        self->log, 'Reading ' + file
        result = FILE_INFO(file)
;        self->log, 'result.size = ' + strtrim(string(result.size), 2) + ' bytes'
        number_of_packets = result.size / self.packet_size
        self.number_of_received_packets = number_of_packets
;;;        self->log, 'Expecting to read ' + strtrim(string(number_of_packets), 2) + ' packets'
;;;        self->log, 'Required number of packets is ' + strtrim(string(self.number_of_expected_packets), 2)

        if number_of_packets eq 0 then begin
           self->log, 'No packets read from ' + file
        endif else begin

           ;; not necessary if using read_binary
           ;; packet_array = replicate(self.sts1_data, number_of_packets)

           ;; packet_array = read_binary(file, DATA_DIMS = [number_of_packets, self.packet_size], ENDIAN = 'big')
           self->read_file, file, packet_array
           n_packet_array = n_elements(packet_array)

           padding = 0

           if self.padding ne 0 then begin
           ;; Construct timing file name from source file
           ;; eis_sts1_yyyymmdd_hhmmssxxxx_sts1 -> yyyymmdd_hhmm_STS1.txt
              hhmm = strmid(file_basename(file), 8, 13)	; Unless the full path is given
;;;              print, 'file_basename(file) = ' + file_basename(file)
;;;              print, 'hhmm = ' + hhmm
;;;              print, 'start_date = ' + self.start_date
;;;              print, 'end_date   = ' + self.end_date

;;              timing_file = self.timing_files_directory + '/' + hhmm + '_' + self.hk_suffix + '.txt'
;;;;;;              timing_file = self.timing_files_directory + '/' + self.hk_suffix + '_*' + hhmm + '.log'
              timing_file = self.timing_files_directory + '/' + self.hk_suffix + '_' + hhmm + '.log'
;;;;;;;;;;;;;;;;;;;;;              timing_file = self.timing_files_directory + '/' + self.hk_suffix + '_' self.start_date + '_' + hhmm + '.log'
;;;              print, 'timing_file = ' + timing_file

              self.timing_file = timing_file
           ;; Add path to timing_file ?
           ;; t_file = timing_files[timing_file_number]
           ;; self->read_timing_data, t_file, timing_data
              self->read_timing_data, timing_file, timing_data
              n_timing_data = n_elements(timing_data)

              if n_packet_array ne n_timing_data then begin
                 print, 'Timing file should have same number of elements as packet array'
                 print, 'File ' + file + ' has ' + strtrim(string(n_packet_array), 2) + ' packets'
                 ;; print, 'File ' + t_file + ' has ' + strtrim(string(n_timing_data), 2) + ' elements'
                 print, 'File ' + timing_file + ' has ' + strtrim(string(n_timing_data), 2) + ' elements'
                 stop
              endif

              ;; timing_file_number = timing_file_number + 1
           
;;;           self->determine_padding, packet_array, timing_data, padding, src, dest, lengths
              padding = self->determine_padding(timing_data, pntrs)

           ; Reduce these parameters to just one
              self.padding = padding
              self.data_padded = padding eq 1
              self.data_missing = self.data_padded

              if padding eq 0 then begin
                 src = 0
                 dest = 0
                 lengths = 0
              endif
           
              help, file, packet_array, pntrs, self.n_gaps
           endif

;;;           self->make_fits_file, file, packet_array
;;;;           self->make_fits_file, file, packet_array, src, dest, lengths
           self->make_fits_file, file, packet_array, pntrs
           self.padding = 1

        endelse
        
;;;        self->debug
        self->report

     end ; foreach

  endelse

end
  
