
pro eis_status_reformatter::write_data, lu, data, col, row, name
	self->trace, 'eis_status_reformatter::write_data'
  errmsg = ''
  fxbwrite, lu, data, col, row, errmsg=errmsg
  if errmsg ne '' then self->log, '*** fxbwrite error for ' + name + ': ' + errmsg
end

pro eis_status_reformatter::create_header, lu, fits_file, header
	self->trace, 'eis_status_reformatter::create_header'
  errmsg = ''
  fxbcreate, lu, fits_file, header, errmsg = errmsg
  if errmsg ne '' then self->log, '*** fxbcreate error: ' + errmsg
end

pro eis_status_reformatter::close_fits_file, lu
	self->trace, 'eis_status_reformatter::close_fits_file'
	; Finish up, fxbfinish disposes of lun
  errmsg = ''
  fxbfinish, lu, errmsg=errmsg
  if errmsg ne '' then self->log, '*** fxbfinish error: ' + errmsg
end

; Make the primary header
pro eis_status_reformatter::make_primary_header, header
	self->trace, 'eis_status_reformatter::make_primary_header'
	fxhmake, header, /initialize, /date, /extend
end

;pro eis_status_reformatter::make_extension_header, header, extension_name, extension_comment
;	errmsg = ''
;	fxbhmake, header, 1, extension_name, extension_comment, errmsg=errmsg, /date, /initialize, /extver, /extlevel
;	if errmsg ne '' then self->log, '*** fxbhmake error: ' + errmsg
;end

; Add the primary header keywords
pro eis_status_reformatter::add_primary_header_keywords, header
	self->trace, 'eis_status_reformatter::add_primary_header_keywords'

	fxaddpar, header, 'origin',   'ISAS',                 'Institute where file was written'
  fxaddpar, header, 'telescop', 'Hinode',               'Satellite name (Solar-B)'
  fxaddpar, header, 'instrume', 'EIS',                  'EUV Imaging Spectrometer'
  fxaddpar, header, 'program',  'eis_make_status_fits', 'Program used to generate the file'
  fxaddpar, header, 'version',  '1.0',                  'Program version'
  fxaddpar, header, 'release',  'Final Reformat',       'Confidence level'

	fxaddpar, header, 'gndtime', self.grt,                              'Archive ground receive time'
  fxaddpar, header, 'ti0',     string(self.sc_start, format='(Z08)'), 'Archive start time - Spacecraft time (TI)'
  fxaddpar, header, 'ti1',     string(self.sc_end, format='(Z08)'),   'Archive end time - Spacecraft time (TI)'

	ut_start1 = self->eis_convert_utc(self.ut_start)
	ut_end1   = self->eis_convert_utc(self.ut_end)

	fxaddpar, header, 'date_obs', ut_start1,                     'Archive start time (UT)'
	fxaddpar, header, 'date_end', ut_end1,                       'Archive end time (UT)'
	fxaddpar, header, 'ti_conv',  self.ti_conv eq 1 ? 'T' : 'F', 'Conversion to UT success'

	fxaddpar, header, 'interval', self.packet_interval_time, 'Packet frequencey (seconds)'

	fxaddpar, header, 'missing',  self.data_missing eq 1 ? 'T' : 'F', 'There are gaps in the data'
	fxaddpar, header, 'n_gaps',   self.n_gaps,                   'Number of gaps in the data'
	fxaddpar, header, 'n_sample', self.n_samples_missing,        'Number of samples missing from the data'
end
