;+
; PROJECT
;           SOLARB EIS
;
; NAME
;           DB_READ_SCIENCESTUDYRASTER_ENTRY
;
; PURPOSE
;           This function reads the SCIENCE2 database and returns a
;           study_raster structure
;
; NOTES
;
; CATEGORY
;           EIS Database
;
; WRITTEN
;           John A Rainne RAL
;
; VERSION
;           v0.1 JAR 2-Apr-2007
;               Removed STO P from function
;           v0.2 JAR 13-Apr-2007
;               Calculate raster width - using "eis_get_total_raster_width"
;
;------------------------------------------------------------------------------;
FUNCTION db_read_sciencestudyraster_entry , id , index

status     = eis_open_db(/SCI_2)
constraint = 'SN_ID =' + string(id) + ',RA_INDEX =' + string(index)
entry      = dbfind(constraint , /SILENT , count = count)
IF (count EQ 0) THEN BEGIN

    print,STRCOMPRESS(id,/REMOVE)
    RETURN , {eis_study_raster}
    ;548
    ;560


ENDIF ELSE BEGIN

    entry = entry[0]

ENDELSE

ra                = {eis_study_raster}
ra.ra_index       = dbval(entry , 'RA_INDEX')
ra.ra_id          = dbval(entry , 'RA_ID')
ra.ra_repeats     = dbval(entry , 'RA_REPEATS')
ra.ra_nwindows    = dbval(entry , 'RA_NWINDOWS')
ra.ra_compression = dbval(entry , 'RA_COMPRESSION')
ra.ra_duration    = dbval(entry , 'RA_DURATION')
ra.ra_volume      = dbval(entry , 'RA_VOLUME')
ra.asrc_enabled   = dbval(entry , 'ASRC_ENABLED')
ra.asrc_direction = dbval(entry , 'ASRC_DIRECTION')
ra.asrc_skip      = dbval(entry , 'ASRC_SKIP')
ra.asrc_nSteps    = dbval(entry , 'ASRC_NSTEPS')
ra.mip            = dbval(entry , 'MIP')
ra.yip            = dbval(entry , 'YIP')
ra.x_point        = dbval(entry , 'X_POINT')
ra.y_point        = dbval(entry , 'Y_POINT')
ra.cmp            = dbval(entry , 'CMP')
ra.ra_start_time  = dbval(entry , 'RA_START_TIME')
ra.ra_stop_time   = dbval(entry , 'RA_STOP_TIME')
ra.sc_x           = dbval(entry , 'SC_X')
ra.sc_y           = dbval(entry , 'SC_Y')

;!quiet=0
;message,'ra is as follows:',/info
;help,ra,/str
;!quiet=1

aec = {eis_aec_props}
aec.aec_flag = dbval(entry, 'RA_AEC_FLG')
e = dbval(entry, 'RA_AEC_PROPS')
    aec.upper_threshold = e[0]
    aec.lower_threshold = e[1]
    aec.upper_count_limit = e[2]
    aec.lower_count_limit = e[3]
    aec.exposure_id = e[4]
    aec.max_run_time = e[5]
ra.aec_props = aec

flare = {eis_flare_props}
flare.flare_flag = dbval(entry, 'RA_EIS_FLR_FLG')
e = dbval(entry, 'RA_EIS_FLR_PROPS')
    flare.x_centre = e[0]
    flare.y_centre = e[1]
    flare.x_pixel_threshold = e[2]
    flare.y_pixel_threshold = e[3]
    flare.x_min_limit = e[4]
    flare.y_min_limit = e[5]
ra.eis_flare_props = flare

event = {eis_event_props}
event.event_flag = dbval(entry, 'RA_EIS_EVT_FLG')
e = dbval(entry, 'RA_EIS_EVT_PROPS')
    event.x_pixel_threshold = e[0]
    event.y_pixel_threshold = e[1]
    event.x_min_limit = e[2]
    event.y_min_limit = e[3]
ra.eis_event_props = event

xrt = {xrt_flare_props}
e = dbval(entry, 'RA_XRT_PROPS')
    xrt.xrt_flag = e
ra.xrt_flare_props = xrt

dbclose



; OK, retrieve even more stuff from the raster DB
eis_raster          = db_read_raster_entry(ra.ra_id)
;!quiet=0
;message,'eis_raster is as follows:',/info
;help,eis_raster,/str
;!quiet=1
ra.ra_acronym       = eis_raster.acronym
ra.ra_title         = eis_raster.title
ra.ll_id            = eis_raster.ll_id
ra.windHeight       = eis_raster.windHeight
ra.scan_fm_nsteps   = eis_raster.scan_fm_nsteps   
ra.scan_fm_stepSize = eis_raster.scan_fm_stepSize
ra.slitindex        = eis_raster.slitindex
ra.rastertype       = eis_raster.rastertype
ra.ra_width         = eis_get_total_raster_width(eis_raster)

;!quiet=0
;message,'ra is now as follows:',/info
;help,ra,/str
;!quiet=1

RETURN , ra

END
