;+
; NAME:
;       HW_HDR__DEFINE
;
; PURPOSE:
;       Defines the class HW_HDR. This is the superclass for header
;       objects used by the Hansteen/Wikstl data analysis SW. It
;       contains nothing except defines the general structure for header
;       objects. The HW_HDR class is inherited by header classes for a
;       specific data source. 
;       
;
; CATEGORY:
;       Hansteen/Wikstol Data analysis SW
;
; CALLING SEQUENCE:
;       
;
; INPUTS:
;      None
;
; KEYWORD PARAMETERS:
;
;
; OUTPUTS:
;       None
;
; CALLS:
;       
;
; COMMON BLOCKS:
;       
;
; PROCEDURE:
;       Defines the structure of header class objects.
;
; RESTRICTIONS:
;
;
; MODIFICATION HISTORY:
;       XX-Aug-2001: Viggo Hansteen
;       20-Sep-2001: Oivind Wikstol. Added documentation.
;       13-Oct-2004: Oivind Wikstol. Added line_id
;       14-Oct-2004: Oivind Wikstol. Added nccd as instance to data
;                     object
;       25-Oct-2004: Oivind Wikstol - Added ver_no with methods (get/set)
;       10-Feb-2007: Viggo Hansteen - Added help methods.
;        4-Jul-2008: A. Gardini     - Added HELP and INIT_HW_METHODS methods.
;                                     Switched setver_no and getver_no methods 
;                                     from eis_hdr to hw_hdr.
;    
; $Id: hw_hdr__define.pro,v 1.8 2008/08/18 14:47:02 viggoh Exp $
;-
function hw_hdr::init
  self->init_hw_methods ; initialization of the help method
  self.help=obj_new('hw_help')
  self.title='HW Header'
  return,1
end

pro hw_hdr::cleanup
  obj_destroy,self.help
end

pro hw_hdr::display_all,init=init
  if n_elements(init) eq 1 then return
  self.help->display_all
  return
end

pro hw_hdr::display_methods,init=init
  if n_elements(init) eq 1 then return
  self.help->display_methods
  return
end

pro hw_hdr::read,init=init
  if n_elements(init) eq 1 then return
end

pro hw_hdr::display,init=init
  if n_elements(init) eq 1 then return
end

function hw_hdr::gettitle,init=init
  if n_elements(init) eq 1 then return,-1
  return, self.title
end

function hw_hdr::getxcen,init=init
  if n_elements(init) eq 1 then return,-1
  return, self.xcen
end

function hw_hdr::getycen,init=init
  if n_elements(init) eq 1 then return,-1
  return, self.ycen
end

function hw_hdr::getnccd,init=init
  if n_elements(init) eq 1 then return,-1
  return, self.nccd
end

function hw_hdr::getline_id,init=init
  if n_elements(init) eq 1 then return,-1
  return, self.line_id
end

pro hw_hdr::setline_id,line_id,init=init
  if n_elements(init) eq 1 then return
  self.line_id=line_id
end

function hw_hdr::getver_no,init=init
  if n_elements(init) eq 1 then return,-1
  return, self.ver_no
end

pro hw_hdr::setver_no, ver_no,init=init
  if n_elements(init) eq 1 then return
  self.ver_no = ver_no
  return
end

pro hw_hdr::help
  help,self,/obj
  return
end

pro hw_hdr::init_hw_methods 

  self->display_all,/init
  self->display_methods,/init
  self->read,/init
;  self->display,/init
  a=self->gettitle(/init)
  a=self->getxcen(/init)
  a=self->getycen(/init)
  a=self->getnccd(/init)
  a=self->getline_id(/init)
  a=self->getver_no(/init)
  self->setver_no,/init

  return
end

pro hw_hdr__define
  nwin = 25  ; max number of line windows for EIS
  struct={hw_hdr,title:' ',$
                 help:obj_new(), $
                 ver_no:0, $
                 line_id:strarr(nwin), $
                 xcen:-1800., $
                 ycen:-1800.,$
                 nccd:0}
end

