function doy2ymd, doyn
  d = doy2ex(doyn) ;       0       0       0       0       6       3      22
  ymd = string(d[6], format = '20%02d') + string(d[5], format = '%02d') + string(d[4], format = '%02d')
  return, ymd
end

; Extract DATE_OBS and DATE_END for each fits file.
; Format for the dates is '2022-06-01T06:07:20.000'
; yyyymmdd is the date for the soda directory...
; fxhmodify needs the fits files to be gunzipped...
; current keyword set when not doing historical files
;pro create_starts, yyyymmdd
;pro satrot, fits_dir,  current=current
;;;pro satrot, current=current
pro satrot, fits_dir, current=current

  start_csv = ''
  end_csv   = ''
  
;  fits_dir = getenv('HOME') + '/data/staging/satrot/test/'
;;;  fits_dir = getenv('HOME') + '/work/localdata/pipeline/fits/'
  csv_dir  = getenv('HOME') + '/data/staging/satrot/csv/'
  log      = getenv('HOME') + '/data/staging/logs/sat_rot/log.txt'

  now = systime()

  openw, lu, log, /get_lun, /append

  printf, lu
  printf, lu, 'Started : ' + now

;  csv_out = './date_and_times.csv'
  
  files = file_search(fits_dir + '/*fits', count=n_fits_files)

  if n_fits_files eq 0 then begin
     printf, lu, 'No fits files'
     print, 'Aargh! No fits files!'
  endif else begin

     printf, lu, strtrim(string(n_fits_files), 2) + ' fits files found'

     ;print, files
                                ; Arrays to store fits filenames, raster
                                ; start/end dates/times and existing instr_rot
     start_dates = strarr(n_fits_files)
     start_times = strarr(n_fits_files)
     end_dates = strarr(n_fits_files)
     end_times = strarr(n_fits_files)
     filenames = strarr(n_fits_files)
     instr_rots = fltarr(n_fits_files)

                                ; Read all the fits files and get the
                                ; raster start and end date/times and instr_rot
     for i = 0, n_fits_files - 1 do begin
        fxread, files[i], d, header
        date_obs  = fxpar(header, 'DATE_OBS', count=start_count)
        date_end  = fxpar(header, 'DATE_END', count=end_count)
        instr_rot = fxpar(header, 'INST_ROT', count=rot_count)

        if start_count ne 0 and end_count ne 0 then begin

                                ; Get the date/time format to be the same as in the .csv file
           res1 = strsplit(date_obs, 'T', /extract)
           res2 = strsplit(date_end, 'T', /extract)

           start_date = res1[0]
           start_time = res1[1]
           end_date   = res2[0]
           end_time   = res2[1]

           start_dates[i] = start_date
           start_times[i] = start_time
           end_dates[i] = end_date
           end_times[i] = end_time
           filenames[i] = files[i]
           ; Instr_rot never changes?
           if rot_count ne 0 then instr_rots[i] = instr_rot else instr_rots[i] = 0.0

           print, files[i]
           print, 'START DATE ', start_date
           print, 'END   DATE ', end_date
           print, 'START TIME ', start_time
           print, 'END   TIME ', end_time
           print
        endif else begin
           print, 'Didnt get dates from fits file ' + files[i]
           printf, 'Didnt get dates from fits file ' + files[i]
        endelse
     endfor
     
;     write_csv, csv_out, filenames, start_dates, start_times, end_dates, end_times

                                ; Read in .csv file(s). Will need more
                                ; than one when the raster goes
                                ; through midnight.

     ;;;foo = where(start_dates[0] ne end_dates, scount)
     foo = where(start_dates[0] ne end_date, scount)
     print, 'scount = ', scount
     print, 'foo = ', foo

     if scount ne 0 then begin
        print, 'Got to deal with cases which go into the next day or beyond...'

        sdate = start_dates[0]
        edate = end_dates[n_fits_files - 1]

        sdoy = doy(sdate)
        edoy = doy(edate)
        print, 'DOY sdate = ', sdoy
        print, 'DOY edate = ', edoy
        print, doy2ex(sdoy + 1, /string)
        print, doy2ex(sdoy + 1)
; 6-MAR-22
;       0       0       0       0       6       3      22
        time_field = []
        rot_angle = []
        start = 1
        while sdoy le edoy do begin
           print, 'Get csv file for ', sdoy
           ymd = doy2ymd(sdoy)
           if start then begin
              start = 0
              start_csv = ymd + '.csv'
           endif else end_csv = ymd + '.csv'
           csv_file = csv_dir + ymd + '.csv'
           print, 'Reading from ' + csv_file
           csv_data = read_csv(csv_file, n_table_header = 1, count = read_count)
           time_field = [time_field, csv_data.field1]
           rot_angle = [rot_angle, csv_data.field2]
           help, time_field, rot_angle
           sdoy = sdoy + 1
        endwhile

     endif else begin
        start_date = strjoin(strsplit(start_dates[0], '-', /extract), '')
        csv_file = csv_dir + start_date + '.csv'
        print, 'Reading from ' + csv_file
        start_csv = file_basename(csv_file, '.csv') + '.csv'
        end_csv = start_csv
        csv_data = read_csv(csv_file, n_table_header = 1, count = read_count)
        help, csv_data, /structures
        print, read_count
        time_field = csv_data.field1
        rot_angle = csv_data.field2
     endelse

     mod_count = 0
     printf, lu, 'Start csv file = ' + start_csv + ', end csv file = ' + end_csv

     for i = 0, n_fits_files - 1 do begin

        modified = 0
        
        start_date_time = start_dates[i] + ' ' + start_times[i]
        end_date_time   = end_dates[i]   + ' ' + end_times[i]
        print, start_date_time + ' ->  ' + end_date_time

;;;        r = where((time_field gt start_date_time) and (time_field lt end_date_time), wcount)
;;;;        r = where((time_field ge start_date_time) and (time_field le end_date_time), wcount)
        r = where((start_date_time le time_field) and (end_date_time ge time_field), wcount)

        if wcount ne 0 then begin

           med = median(rot_angle[r], /even)
           men = mean(rot_angle[r])
           print, 'WCOUNT ', wcount, ' r = ', r
           print, 'TIME ', time_field[r]
           print, 'ROT  ', rot_angle[r]
           print, 'MEDIAN = ', med
           print, 'MEAN   = ', men
           print, 'TIMES  = ', time_field[r]
           sat_rot = men
           modified = 1
           
        endif else begin

;;;           wgt = where(time_field gt start_date_time, gtcount)
;;;;           wgt = where(time_field ge start_date_time, gtcount)
           wgt = where(start_date_time le time_field, gtcount)
           if gtcount ne 0 then begin
              hi = wgt[0]
              print, 'GT count = ', gtcount
              print, 'WGT      = ', wgt[0], ' ', wgt[gtcount - 1]
              print, 'HI       = ', hi
           endif else print, 'Time not ge start date time ', gtcount

;;;           wlt = where(time_field lt end_date_time, ltcount)
;;;;           wlt = where(time_field le end_date_time, ltcount)
           wlt = where(end_date_time ge time_field, ltcount)
           if ltcount ne 0 then begin
              lo = wlt[ltcount - 1]
              print, 'LT count = ', ltcount
              print, 'WLT      = ', wlt[ltcount - 1], ' ' , wlt[0]
              print, 'LO       = ', lo
           endif else print, 'Time not le than end date time'

           if gtcount eq 0 and ltcount ne 0 then hi = lo
           if ltcount eq 0 and gtcount ne 0 then lo = hi

           if gtcount eq 0 and ltcount eq 0 then modified = 0 else modified = 1

           if modified then begin
              arr = [rot_angle[lo], rot_angle[hi]]
              med = median(arr, /even)
              men = mean(arr)
              print, 'MEDIAN = ', med
              print, 'MEAN   = ', men
              print, 'ANGLES = ', arr
              print, 'TIMES  = ', [time_field[lo], time_field[hi]]
              sat_rot = men
           endif
        endelse

        if modified then begin
                                ; CROTA1 = CROTA2 = SAT_ROT + INST_ROT
           crota1 = sat_rot + instr_rots[i]
           crota2 = crota1
           now = systime(/utc)
           print, 'now = ' + now
           print, 'Adding history keyword to file ' + files[i]
           print, 'Start csv file = ' + start_csv + ', end csv file = ' + end_csv
           if keyword_set(current) then begin
              printf, lu, now + ' Adding history keyword to ' + files[i]
              desc_str = 'Set with satrot.pro v1'
              hist_str = 'sat_rot,crota1,crota2 set by satrot.pro v1'
;              hist1_str = 'on ' + now
              hist2_str = 'csv files used ' + start_csv + 'to ' + end_csv

              fxhmodify, files[i], 'CROTA1', crota1, desc_str
              fxhmodify, files[i], 'CROTA2', crota2, desc_str
              fxhmodify, files[i], 'SAT_ROT', sat_rot, desc_str
              fxhmodify, files[i], 'HISTORY', hist_str, ''
;              fxhmodify, files[i], 'HISTORY', hist1_str, ''
              fxhmodify, files[i], 'HISTORY', hist2_str, ''
              
              fxhmodify, files[i], 'CROTA1', crota1, desc_str, extension=1
              fxhmodify, files[i], 'CROTA2', crota2, desc_str, extension=1
              fxhmodify, files[i], 'SAT_ROT', sat_rot, desc_str, extension=1
              fxhmodify, files[i], 'HISTORY', hist_str, '', extension=1
;              fxhmodify, files[i], 'HISTORY', hist1_str, '', extension=1
              fxhmodify, files[i], 'HISTORY', hist2_str, '', extension=1
              print
              ;printf, lu, files[i] + ' set satrot ' + strtrim(string(sat_rot),2) + ', crota1,2 ' + strtrim(string(crota1),2)
           endif else begin
              printf, lu, now + ' Updating history keyword for ' + files[i]
              desc_str = 'Updated with satrot.pro v1'
              hist_str = 'sat_rot,crota1,crota2 updated by satrot.pro v1'
              hist1_str = 'on ' + now
              hist2_str = 'csv files used ' + start_csv + 'to ' + end_csv

              fxhmodify, files[i], 'CROTA1', crota1, desc_str
              fxhmodify, files[i], 'CROTA2', crota2, desc_str
              fxhmodify, files[i], 'SAT_ROT', sat_rot, desc_str
              fxhmodify, files[i], 'HISTORY', hist_str, ''
              fxhmodify, files[i], 'HISTORY', hist1_str, ''
              fxhmodify, files[i], 'HISTORY', hist2_str, ''
              
              fxhmodify, files[i], 'CROTA1', crota1, desc_str, extension=1
              fxhmodify, files[i], 'CROTA2', crota2, desc_str, extension=1
              fxhmodify, files[i], 'SAT_ROT', sat_rot, desc_str, extension=1
              fxhmodify, files[i], 'HISTORY', hist_str, '', extension=1
              fxhmodify, files[i], 'HISTORY', hist1_str, '', extension=1
              fxhmodify, files[i], 'HISTORY', hist2_str, '', extension=1
              print
              ;printf, lu, files[i] + ' updated satrot ' + strtrim(string(sat_rot),2) + ', crota1,2 ' + strtrim(string(crota1),2)
           endelse
           mod_count = mod_count + 1
        endif else begin
           if keyword_set(current) then begin
              printf, lu, now + ' Adding FAILED history keyword to ' + files[i]
              print, 'Adding FAILED history keyword to file ', + files[i]
              fxhmodify, files[i], 'HISTORY', 'Failed to update SAT_ROT', ''
              fxhmodify, files[i], 'HISTORY', 'Failed to update SAT_ROT', '', extension=1
              ;printf, lu, files[i] + ' failed (current)'
           endif else begin
              printf, lu, now + ' Updating FAILED history keyword for '
              print, 'Adding FAILED history keyword to file ', + files[i]
              fxhmodify, files[i], 'HISTORY', 'Failed to update SAT_ROT', ''
              fxhmodify, files[i], 'HISTORY', 'Failed to update SAT_ROT', '', extension=1
              ;printf, lu, files[i] + ' failed (update)'
           endelse
           mod_count = mod_count + 1
        endelse
        
     endfor
     
  endelse

  now = systime()
  printf, lu, now + ' finished: ' + strtrim(string(mod_count), 2) + ' files modified'

  close, lu
  free_lun, lu

;  print, 'File median = ', median(rot_angle, /even)
;
;  csv_data = read_csv('/Users/mcrw/Downloads/20220602.csv', n_table_header = 1, count = read_count)
;  foo = where(csv_data.field3 ne 8, fcount)
;  print, 'fcount = ', fcount
;;;;  print, 'File median = ', median(csv_data.field2, /even)
;  print, 'File median = ', median(csv_data.field2[foo], /even)
;  print, 'File mean   = ', mean(csv_data.field2[foo])
  
end

;2022-03-05 20:35:27.000 ->  2022-03-05 20:35:37.000
;WCOUNT           2         948         949
;2022-03-05 20:35:28.514 2022-03-05 20:35:32.373
;       2.8876900       2.7997900
;       2.8876900

;2022-03-05 20:37:45.000 ->  2022-03-05 20:37:55.000
;GT         288         952
;2022-03-05 20:39:25.937
;LT         952         951
;2022-03-05 20:35:42.375
;MEDIAN =        3.0158800
