;+
; NAME: eis_status_sts1_conversions.pro
;
; PURPOSE: To convert EIS status 1 parameters from telemetered values
;          to engineering values
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	24/November/2006 v1.0 mcrw wrote
;
;-------------------------------------------------------------------------------------------------
; files - string array of filenames in time order
; output - string pathname to where to write ps files
;

pro mdp_status_check, files, lu
  tmp = eis_get_daily_data(files, 'CMD_EIS_SRQ_CNT',  1, 1, maxp1,  minp1, start_time, end_time)
;  mom = moment(tmp)
;  avgp1 = mom[0]
  tmp = eis_get_daily_data(files, 'CMD_EIS_DHU_CNT',  2, 1, maxp2,  minp2)
;  mom = moment(tmp)
;  avgp2 = mom[0]
  tmp = eis_get_daily_data(files, 'STS_EIS_RP1_CNT',  3, 1, maxp3,  minp3)
;  mom = moment(tmp)
;  avgp3 = mom[0]
  tmp = eis_get_daily_data(files, 'STS_EIS_RP2_CNT',  4, 1, maxp4,  minp4)
;  mom = moment(tmp)
;  avgp4 = mom[0]
  tmp = eis_get_daily_data(files, 'STS_EIS_RP3_CNT',  5, 1, maxp5,  minp5)
;  mom = moment(tmp)
;  avgp5 = mom[0]
  tmp = eis_get_daily_data(files, 'STS_EIS_RP4_CNT',  6, 1, maxp6,  minp6)
;  mom = moment(tmp)
;  avgp6 = mom[0]
  tmp = eis_get_daily_data(files, 'STS_EIS_ERR',      7, 1, maxp7,  minp7)
;  mom = moment(tmp)
;  avgp7 = mom[0]
  tmp = eis_get_daily_data(files, 'STS_EIS_RCV',      8, 1, maxp8,  minp8)
;  mom = moment(tmp)
;  avgp8 = mom[0]
  tmp = eis_get_daily_data(files, 'STS_EIS_ERR_TIM',  9, 1, maxp9,  minp9)
;  mom = moment(tmp)
;  avgp9 = mom[0]
  tmp = eis_get_daily_data(files, 'IMG_EIS_BUSY',    10, 1, maxp10, minp10)
;  mom = moment(tmp)
;  avgp10 = mom[0]
  tmp = eis_get_daily_data(files, 'IMG_EIS_QUE_SIZ', 11, 1, maxp11, minp11)
;  mom = moment(tmp)
;  avgp11 = mom[0]
  tmp = eis_get_daily_data(files, 'IMG_EIS_RCV_CNT', 12, 1, maxp12, minp12)
;  mom = moment(tmp)
;  avgp12 = mom[0]
  tmp = eis_get_daily_data(files, 'IMG_EIS_RCV_SIZ', 13, 1, maxp13, minp13)
;  mom = moment(tmp)
;  avgp13 = mom[0]
  tmp = eis_get_daily_data(files, 'EIS_FLR_FLG',     14, 1, maxp14, minp14)
;  mom = moment(tmp)
;  avgp14 = mom[0]
  tmp = eis_get_daily_data(files, 'EIS_FLR_LOC_X',   15, 1, maxp15, minp15)
;  mom = moment(tmp)
;  avgp15 = mom[0]
  tmp = eis_get_daily_data(files, 'EIS_FLR_LOC_Y',   16, 1, maxp16, minp16)
;  mom = moment(tmp)
;  avgp16 = mom[0]


;  title_str = 'EISMDP status                   min            max                avg'
  title_str = 'EISMDP status                   min            max'

  frmt = 'count'
;  p0_str  = eis_param_string('HK1_EIS_ON_OFF        ', frmt, minp1,  maxp1) + '	'  + eis_num2str(avgp1, type=frmt)
  p0_str   = eis_param_string('CMD_EIS_SEQ_CNT       ', frmt, minp1,  maxp1)
  p1_str   = eis_param_string('CMD_EIS_DHU_CNT       ', frmt, minp2,  maxp2)
  p2_str   = eis_param_string('STS_EIS_RP1_CNT       ', frmt, minp3,  maxp3)
  p3_str   = eis_param_string('STS_EIS_RP2_CNT       ', frmt, minp4,  maxp4)
  p4_str   = eis_param_string('STS_EIS_RP3_CNT       ', frmt, minp5,  maxp5)
  p5_str   = eis_param_string('STS_EIS_RP4_CNT       ', frmt, minp6,  maxp6)
  p6_str   = eis_param_string('STS_EIS_ERR           ', frmt, minp7,  maxp7)
  p7_str   = eis_param_string('STS_EIS_RCV           ', frmt, minp8,  maxp8)
  p8_str   = eis_param_string('STS_EIS_ERR_TIM       ', frmt, minp9,  maxp9)
  p9_str   = eis_param_string('IMG_EIS_BUSY          ', frmt, minp10, maxp10)
  p10_str  = eis_param_string('IMG_EIS_QUE_SIZ       ', frmt, minp11, maxp11)
  p11_str  = eis_param_string('IMG_EIS_RCV_CNT       ', frmt, minp12, maxp12)
  p12_str  = eis_param_string('IMG_EIS_RCV_SIZ       ', frmt, minp13, maxp13)
  p13_str  = eis_param_string('EIS_FLR_FLG           ', frmt, minp14, maxp14)
  p14_str  = eis_param_string('EIS_FLR_LOC_X         ', frmt, minp15, maxp15)
  p15_str  = eis_param_string('EIS_FLR_LOC_Y         ', frmt, minp16, maxp16)

  if n_elements(lu) ne 0 then begin
     print, '	mdp_status_check'
     printf, lu, title_str
     printf, lu, p0_str
     printf, lu, p1_str
     printf, lu, p2_str
     printf, lu, p3_str
     printf, lu, p4_str
     printf, lu, p5_str
     printf, lu, p6_str
     printf, lu, p7_str
     printf, lu, p8_str
     printf, lu, p9_str
     printf, lu, p10_str
     printf, lu, p11_str
     printf, lu, p12_str
     printf, lu, p13_str
     printf, lu, p14_str
     printf, lu, p15_str
     printf, lu
  endif

 end

pro eis_status_mdp_check, dir, lu

  print, 'eis_status_mdp_check'

    files = findfile(dir + 'eis_eismdp_*fits*', count=count)
    if count eq 0 then begin
;        print, 'eis_status_mdp_check'
        print, '	No files'
        return
    endif

    if n_elements(lu) ne 0 then begin
;        print, 'eis_status_mdp_check'
        mdp_status_check,   files, lu
        return
    endif

    status_check, files

end
