;+
; NAME: eis_status_sts1_conversions.pro
;
; PURPOSE: To convert EIS status 1 parameters from telemetered values
;          to engineering values
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	24/November/2006 v1.0 mcrw wrote
;
;-------------------------------------------------------------------------------------------------
; files - string array of filenames in time order
; output - string pathname to where to write ps files
;
pro sot_status_check, files, lu
  tmp = eis_get_daily_data(files, 'MDP_DSC_V_SAT', 1,  1, maxp1, minp1, start_time, end_time)
  mom = moment(tmp)
  avgp1 = mom[0]
  tmp = eis_get_daily_data(files, 'MDP_DSC_V_SUN', 2,  1, maxp2, minp2)
  mom = moment(tmp)
  avgp2 = mom[0]
  tmp = eis_get_daily_data(files, 'MDP_DSC_V_ETH', 3,  1, maxp3, minp3)
  mom = moment(tmp)
  avgp3 = mom[0]
  tmp = eis_get_daily_data(files, 'MDP_DSC_V_RST', 4,  1, maxp4, minp4)
  mom = moment(tmp)
  avgp4 = mom[0]

  title_str = 'SOT Doppler                     min            max             avg'

  frmt = 'count'
  p0_str  = eis_param_string('MDP_DSC_V_SAT         ', frmt, minp1,  maxp1) + '	'  + eis_num2str(avgp1, type=frmt)
  p1_str  = eis_param_string('MDP_DSC_V_SUN         ', frmt, minp2,  maxp2) + '	'  + eis_num2str(avgp2, type=frmt)
  p2_str  = eis_param_string('MDP_DSC_V_ETH         ', frmt, minp3,  maxp3) + '	'  + eis_num2str(avgp3, type=frmt)
  p3_str  = eis_param_string('MDP_DSC_V_RST         ', frmt, minp4,  maxp4) + '	'  + eis_num2str(avgp4, type=frmt)


  if n_elements(lu) ne 0 then begin
     print, '	sot_doppler_velocity_check'
     printf, lu, title_str
     printf, lu, p0_str
     printf, lu, p1_str
     printf, lu, p2_str
     printf, lu, p3_str
     printf, lu
  endif

 end


pro eis_status_sot_check, dir, lu

  print, 'eis_status_sot_check'

    files = findfile(dir + 'eis_sot_*fits*', count=count)
    if count eq 0 then begin
;        print, 'eis_status_sot_check'
        print, '	No files'
        return
    endif

    if n_elements(lu) ne 0 then begin
;        print, 'eis_status_sot_check'
        sot_status_check, files, lu
        return
    endif

    status_check, files

end
