;+
; NAME: eis_status_sts1_conversions.pro
;
; PURPOSE: To convert EIS status 1 parameters from telemetered values
;          to engineering values
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	24/November/2006 v1.0 mcrw wrote
;
;-------------------------------------------------------------------------------------------------

pro interface_check, val_array, val1, val2, res

    tmp = where(val_array eq val1, c0)
    tmp = where(val_array eq val2, c1)

    num_readings = n_elements(val_array)
    res = num_readings - (c0 + c1)

end

; files - string array of filenames in time order
; output - string pathname to where to write ps files
;
pro icu_voltages_check, files, lu

;  tmp = eis_get_daily_data_converted(files, 'eis_convert_icu_voltage_p2p5v', 'ICU_P2V5', 1, 1, maxp1, minp1, start_time, end_time)
;  avgp1 = mom[0]

  tmp = eis_get_daily_data(files, 'ICU_P2V5', 1, 1, maxp1, minp1, start_time, end_time)
  mom = moment(tmp)
  avgp1 = eis_convert_icu_voltage_p2p5v([mom[0]])
;  maxp1 = eis_convert_icu_voltage_p2p5v([maxp1])
;  minp1 = eis_convert_icu_voltage_p2p5v([minp1])
  
  tmp = eis_get_daily_data(files, 'ICU_P5V',  2, 1, maxp2, minp2)
  mom = moment(tmp)
  avgp2 = eis_convert_icu_voltage_p5v([mom[0]])
;  maxp2 = eis_convert_icu_voltage_p5v(maxp2)
;  minp2 = eis_convert_icu_voltage_p5v(minp2)
  
  tmp = eis_get_daily_data(files, 'ICU_P15V', 3, 1, maxp3, minp3)
  mom = moment(tmp)
  avgp3 = eis_convert_icu_voltage_p15v([mom[0]])
 
  tmp = eis_get_daily_data(files, 'ICU_N15V', 4, 1, maxp4, minp4)
  mom = moment(tmp)
  avgp4 = eis_convert_icu_voltage_n15v([mom[0]])

  tmp = eis_get_daily_data(files, 'MBUS_28V', 5, 1, maxp5, minp5)
  mom = moment(tmp)
  avgp5 = eis_convert_icu_voltage_mbus28v([mom[0]])
  
  time_str  = 'Start: ' + strtrim(string(start_time), 2) + ' End: ' + strtrim(string(end_time), 2)
  
  title_str = 'ICU voltages (volts)            min            max                avg'
;  title_str = 'ICU voltages (volts)            min            max                avg       range'
  
  p2v5_str = eis_min_max_str('+2.5v                 ', 'volts', 'eis_convert_icu_voltage_p2p5v',  minp1,  maxp1)
;  p2v5_str = eis_min_max_str1('+2.5v                 ', 'volts', minp1,  maxp1)
  p5v_str  = eis_min_max_str('+5v                   ', 'volts', 'eis_convert_icu_voltage_p5v',     minp2,  maxp2)
;  p5v_str  = eis_min_max_str1('+5v                   ', 'volts', minp2,  maxp2)
  p15v_str = eis_min_max_str('+15v                  ', 'volts', 'eis_convert_icu_voltage_p15v',    minp3,  maxp3)
  n15v_str = eis_min_max_str('-15v                  ', 'volts', 'eis_convert_icu_voltage_n15v',    minp4,  maxp4)
  mbus_str = eis_min_max_str('mbus +28v             ', 'volts', 'eis_convert_icu_voltage_mbus28v', minp5,  maxp5)
  
  if n_elements(lu) ne 0 then begin
     print, '	icu_voltages_check'
     printf, lu, time_str
     printf, lu
     printf, lu, title_str
     printf, lu, p2v5_str + '            ' + strtrim(string(avgp1,format='(F7.2)'), 0)
     printf, lu, p5v_str  + '            ' + strtrim(string(avgp2,format='(F7.2)'), 0)
     printf, lu, p15v_str + '            ' + strtrim(string(avgp3,format='(F7.2)'), 0)
     printf, lu, n15v_str + '            ' + strtrim(string(avgp4,format='(F7.2)'), 0)
     printf, lu, mbus_str + '            ' + strtrim(string(avgp5,format='(F7.2)'), 0)

;     printf, lu, p2v5_str + '            ' + strtrim(string(avgp1,format='(F7.2)'), 0) + '     ' + eis_range('eis_convert_icu_voltage_p2p5v',   maxp1, minp1, /float)
;;     printf, lu, p2v5_str + '            ' + strtrim(string(avgp1,format='(F7.2)'), 0) + '     ' + eis_range1(maxp1, minp1, /float)
;     printf, lu, p5v_str  + '            ' + strtrim(string(avgp2,format='(F7.2)'), 0) + '     ' + eis_range('eis_convert_icu_voltage_p5v',     maxp2, minp2, /float)
;;     printf, lu, p5v_str  + '            ' + strtrim(string(avgp2,format='(F7.2)'), 0) + '     ' + eis_range1(maxp2, minp2, /float)
;     printf, lu, p15v_str + '            ' + strtrim(string(avgp3,format='(F7.2)'), 0) + '     ' + eis_range('eis_convert_icu_voltage_p15v',    maxp3, minp3, /float)
;     printf, lu, n15v_str + '            ' + strtrim(string(avgp4,format='(F7.2)'), 0) + '     ' + eis_range('eis_convert_icu_voltage_n15v',    minp4, maxp4, /float)
;     printf, lu, mbus_str + '            ' + strtrim(string(avgp5,format='(F7.2)'), 0) + '     ' + eis_range('eis_convert_icu_voltage_mbus28v', maxp5, minp5, /float)

     printf, lu
  endif else begin
     print, time_str
     print
     print, title_str
     print, p2v5_str
     print, p5v_str
     print, p15v_str
     print, n15v_str
     print, mbus_str
     print
  endelse
end

pro icu_currents_check, files, lu
  
  tmp = eis_get_daily_data(files,'ICU_P2I5', 1, 2, maxp0, minp0, start_time, end_time)
  mom = moment(tmp)
  avgp1 = eis_convert_icu_current_p2p5v([mom[0]])
  tmp = eis_get_daily_data(files,'ICU_P5I',  2, 2, maxp1, minp1)
  mom = moment(tmp)
  avgp2 = eis_convert_icu_current_p5v([mom[0]])
  tmp = eis_get_daily_data(files,'ICU_P15I', 3, 2, maxp2, minp2)
  mom = moment(tmp)
  avgp3 = eis_convert_icu_current_p15v([mom[0]])
  tmp = eis_get_daily_data(files,'ICU_N15I', 4, 2, maxp3, minp3)
  mom = moment(tmp)
  avgp4 = eis_convert_icu_current_n15v([mom[0]])
  tmp = eis_get_daily_data(files,'MBUS_28I', 5, 2, maxp4, minp4)
  mom = moment(tmp)
  avgp5 = eis_convert_icu_current_mbus28v([mom[0]])
  
  title_str = 'ICU currents (amps)             min            max                avg'
;  title_str = 'ICU currents (amps)             min            max                avg       range'
  
  p2v5_str = eis_min_max_str('+2.5v                 ', 'amps', 'eis_convert_icu_current_p2p5v',   minp0,  maxp0)
  p5v_str  = eis_min_max_str('+5v                   ', 'amps', 'eis_convert_icu_current_p5v',     minp1,  maxp1)
  p15v_str = eis_min_max_str('+15v                  ', 'amps', 'eis_convert_icu_current_p15v',    minp2,  maxp2)
  n15v_str = eis_min_max_str('-15v                  ', 'amps', 'eis_convert_icu_current_n15v',    minp3,  maxp3)
  mbus_str = eis_min_max_str('mbus +28v             ', 'amps', 'eis_convert_icu_current_mbus28v', minp4,  maxp4)
  
  if n_elements(lu) ne 0 then begin
     print, '	icu_currents_check'
     printf, lu, title_str
     printf, lu, p2v5_str + '            ' + strtrim(string(avgp1,format='(F7.3)'), 0); + '     ' + eis_range('eis_convert_icu_current_p2p5v',   maxp0, minp0, /float)
     printf, lu, p5v_str  + '            ' + strtrim(string(avgp2,format='(F7.3)'), 0); + '     ' + eis_range('eis_convert_icu_current_p5v',     maxp1, minp1, /float)
     printf, lu, p15v_str + '            ' + strtrim(string(avgp3,format='(F7.3)'), 0); + '     ' + eis_range('eis_convert_icu_current_p15v',    maxp2, minp2, /float)
     printf, lu, n15v_str + '            ' + strtrim(string(avgp4,format='(F7.3)'), 0); + '     ' + eis_range('eis_convert_icu_current_n15v',    minp3, maxp3, /float)
     printf, lu, mbus_str + '            ' + strtrim(string(avgp5,format='(F7.3)'), 0); + '     ' + eis_range('eis_convert_icu_current_mbus28v', maxp4, minp4, /float)
     printf, lu
  endif else begin
     print, title_str
     print, p2v5_str
     print, p5v_str
     print, p15v_str
     print, n15v_str
     print, mbus_str
     print
  endelse
end

pro icu_temperatures_check, files, lu
  
  tmp = eis_get_daily_data(files,'ICU_PROC_TEMP', 3, 3, maxp1, minp1, start_time, end_time)
  mom = moment(tmp)
  avgp1 = eis_convert_icu_proc_temperature([mom[0]])
  tmp = eis_get_daily_data(files,'CCDA_TEMP',     1, 3, maxp2, minp2)
  mom = moment(tmp)
  avgp2 = eis_convert_ccda_temperature([mom[0]])
  tmp = eis_get_daily_data(files,'CCDB_TEMP',     2, 3, maxp3, minp3)
  mom = moment(tmp)
  avgp3 = eis_convert_ccdb_temperature([mom[0]])
  
  title_str = 'ICU temperatures (C)            min            max                avg'
;  title_str = 'ICU temperatures (C)            min            max                avg       range'
  
  icu_str  = eis_min_max_str('Icu proc              ', 'degC', 'eis_convert_icu_proc_temperature', maxp1,  minp1)
  ccda_str = eis_min_max_str('CCD-A                 ', 'degC', 'eis_convert_ccda_temperature',     minp2,  maxp2)
  ccdb_str = eis_min_max_str('CCD-B                 ', 'degC', 'eis_convert_ccdb_temperature',     minp3,  maxp3)
  
  if n_elements(lu) ne 0 then begin
     print, '	icu_temperatures_check'
     printf, lu, title_str
;        printf, lu, icu_str  + '            ' + strtrim(string(avgp1,format='(F7.2)'), 2) + strtrim(string(maxp1 - minp1, format='(F7.2)'), 2)
;        printf, lu, ccda_str + '            ' + strtrim(string(avgp2,format='(F7.2)'), 2) + strtrim(string(maxp2 - minp2, format='(F7.2)'), 2)
;        printf, lu, ccdb_str + '            ' + strtrim(string(avgp3,format='(F7.2)'), 2) + strtrim(string(maxp3 - minp3, format='(F7.2)'), 2)
     printf, lu, icu_str  + '            ' + strtrim(string(avgp1,format='(F7.2)'), 0); + '     ' + eis_range('eis_convert_icu_proc_temperature', maxp1, minp1, /float)
     printf, lu, ccda_str + '            ' + strtrim(string(avgp2,format='(F7.2)'), 0); + '     ' + eis_range('eis_convert_ccda_temperature',     minp2, maxp2, /float)
     printf, lu, ccdb_str + '            ' + strtrim(string(avgp3,format='(F7.2)'), 0); + '     ' + eis_range('eis_convert_ccdb_temperature',     minp3, maxp3, /float)
     printf, lu
  endif else begin
     print, title_str
     print, icu_str
     print, ccda_str
     print, ccdb_str
     print
  endelse
end

pro icu_misc_parameters_check, files, lu
  
  tmp = eis_get_daily_data(files,'ICU_SW_ID',     1, 4, maxp1, minp1, start_time, end_time)
  tmp = eis_get_daily_data(files,'PORT_READ',     2, 4, maxp2, minp2)
  tmp = eis_get_daily_data(files,'LAST_BC1_R',    3, 4, maxp3, minp3)
  tmp = eis_get_daily_data(files,'LAST_BC2_R',    4, 4, maxp4, minp4)
  tmp = eis_get_daily_data(files,'LAST_BC3_R',    5, 4, maxp5, minp5)
  tmp = eis_get_daily_data(files,'LAST_CMD_L_R',  6, 4, maxp6, minp6)
  tmp = eis_get_daily_data(files,'HC_TARGET_T',   7, 4, maxp7, minp7)
  tmp = eis_get_daily_data(files,'HC_DUTY_CYCLE', 8, 4, maxp8, minp8)
  
  title_str = 'ICU Misc Parameters             min            max'
  frmt = 'hex2'
  p0_str  = eis_param_string('ICU software id       ', frmt,     minp1,  maxp1)
  p1_str  = eis_param_string('Port read             ', 'zcount', minp2,  maxp2)
  p2_str  = eis_param_string('Last BC1              ', frmt,     minp3,  maxp3)
  p3_str  = eis_param_string('Last BC2              ', frmt,     minp4,  maxp4)
  p4_str  = eis_param_string('Last BC3              ', frmt,     minp5,  maxp5)
  p5_str  = eis_param_string('Last cmd length       ', frmt,     minp6,  maxp6)
  p6_str  = eis_param_string('HC target temp        ', frmt,     minp7,  maxp7)
;    p6_str  =  eis_min_max_str('HC target temp        ', 'degC', 'eis_convert_icu_temperature',     minp7,  maxp7)
  p7_str  = eis_param_string('HC duty cycle         ', frmt,     minp8,  maxp8)
  
  if n_elements(lu) ne 0 then begin
     print, '	icu_misc_parameters_check'
     printf, lu, title_str
     printf, lu, p0_str
     printf, lu, p1_str
     printf, lu, p2_str
     printf, lu, p3_str
     printf, lu, p4_str
     printf, lu, p5_str
     printf, lu, p6_str
     printf, lu, p7_str
     printf, lu
  endif
end

pro icu_status_parameters_check, files, lu
  
  tmp = eis_get_daily_data(files,'EIS_MODE',             1,  5, maxp1,  minp1, start_time, end_time)
  tmp = eis_get_daily_data(files,'CCD_BUF_TEST_STAT',    2,  5, maxp2,  minp2)
  tmp = eis_get_daily_data(files,'CCD_BUF_TEST_ERR',     3,  5, maxp3,  minp3)
  tmp = eis_get_daily_data(files,'CCD_BUF_TEST_WR_ERR',  4,  5, maxp4,  minp4)
  tmp = eis_get_daily_data(files,'CCD_BUF_TEST_RD_ERR',  5,  5, maxp5,  minp5)
  tmp = eis_get_daily_data(files,'ET_STAT',              6,  5, maxp6,  minp6)
  tmp = eis_get_daily_data(files,'CMD_BUF_STAT',         7,  5, maxp7,  minp7)
  tmp = eis_get_daily_data(files,'XRT_FF_STAT',          8,  5, maxp8,  minp8)
  tmp = eis_get_daily_data(files,'EIS_FF_STAT',          9,  5, maxp9,  minp9)
  tmp = eis_get_daily_data(files,'HM_MON_STAT',          10, 5, maxp10, minp10)
  tmp = eis_get_daily_data(files,'AEC_STAT',             11, 5, maxp11, minp11)
  tmp = eis_get_daily_data(files,'MEM_DMP_STAT',         12, 5, maxp12, minp12)
  tmp = eis_get_daily_data(files,'SEQ_STAT',             13, 5, maxp13, minp13)
  tmp = eis_get_daily_data(files,'MODE_EN_STAT',         14, 5, maxp14, minp14)
  tmp = eis_get_daily_data(files,'XRT_FF_REC',           15, 5, maxp15, minp15)
  tmp = eis_get_daily_data(files,'XRT_X_COR',            16, 5, maxp16, minp16)
  tmp = eis_get_daily_data(files,'XRT_Y_COR',            17, 5, maxp17, minp17)
  tmp = eis_get_daily_data(files,'MD_BUF_STAT',          18, 5, maxp18, minp18)
  tmp = eis_get_daily_data(files,'ICU_VF',               19, 5, maxp19, minp19)
  tmp = eis_get_daily_data(files,'PSU_VF',               20, 5, maxp20, minp20)
  tmp = eis_get_daily_data(files,'CAM_VF',               21, 5, maxp21, minp21)
  tmp = eis_get_daily_data(files,'MHC_VF',               22, 5, maxp22, minp22)
  tmp = eis_get_daily_data(files,'ASRC_STAT',            23, 5, maxp23, minp23)
  tmp = eis_get_daily_data(files,'MHC_LOAD_STAT',        24, 5, maxp24, minp24)
  tmp = eis_get_daily_data(files,'HC_STAT',              25, 5, maxp25, minp25)
  tmp = eis_get_daily_data(files,'EEPROM_STAT1',         26, 5, maxp26, minp26)
  tmp = eis_get_daily_data(files,'EEPROM_STAT2',         27, 5, maxp27, minp27)
  tmp = eis_get_daily_data(files,'EEPROM_COPY_REQ_STAT', 28, 5, maxp28, minp28)
  tmp = eis_get_daily_data(files,'EEPROM_COPY_PROG_STAT',29, 5, maxp29, minp29)
  tmp = eis_get_daily_data(files,'CMS_MHC_PWR_ON',       30, 5, maxp30, minp30)
  
  title_str = 'ICU status                      min            max'
  
  mode_str        = eis_param_string('EIS mode              ', 'count', minp1,  maxp1) + '	(0 = boot,    1 = standby, 2 = manual,  3 = auto, 4 = bakeout, 5 = emergency)'
  p2_str          = eis_param_string('CCD buffer test stat  ', 'count', minp2,  maxp2)
  p3_str          = eis_param_string('CCD buffer test error ', 'count', minp3,  maxp3)
  p4_str          = eis_param_string('CCD buffer test wr err', 'count', minp4,  maxp4)
  p5_str          = eis_param_string('CCD buffer test rd err', 'count', minp5,  maxp5)
  et_str          = eis_param_string('ET stat               ', 'count', minp6,  maxp6)
  cmd_buf_str     = eis_param_string('Cmd buffer stat       ', 'count', minp7,  maxp7)
  xrt_ff_str      = eis_param_string('XRT flare flag stat   ', 'count', minp8,  maxp8)
  eis_ff_str      = eis_param_string('EIS flare flag stat   ', 'count', minp9,  maxp9)
  hm_mon_str      = eis_param_string('Health monitor stat   ', 'count', minp10, maxp10) + '	(1 = running, 2 = stopped, 3 = aborted, 4 = paused)'
  aec_str         = eis_param_string('AEC stat              ', 'count', minp11, maxp11) + '	(1 = running, 2 = stopped, 3 = aborted, 4 = paused)'
  mem_dmp_str     = eis_param_string('Memory dump stat      ', 'count', minp12, maxp12) + '	(1 = running, 2 = stopped, 3 = aborted, 4 = paused)'
  seq_stat_str    = eis_param_string('Seq stat              ', 'count', minp13, maxp13) + '	(1 = running, 2 = stopped, 3 = aborted, 4 = paused)'
  mode_en_str     = eis_param_string('Mode enable stat      ', 'count', minp14, maxp14)
  xrt_ff_rec_str  = eis_param_string('XRT flare flag rec    ', 'count', minp15, maxp15)
  xrt_ff_x_str    = eis_param_string('XRT flare x pos       ', 'count', minp16, maxp16)
  xrt_ff_y_str    = eis_param_string('XRT flare y pos       ', 'count', minp17, maxp17)
  md_buf_str      = eis_param_string('Md buffer stat        ', 'count', minp18, maxp18)
  icu_vf_str      = eis_param_string('ICU vf                ', 'count', minp19, maxp19)
  psu_vf_str      = eis_param_string('PSU vf                ', 'count', minp20, maxp20)
  cam_vf_str      = eis_param_string('CAM vf                ', 'count', minp21, maxp21)
  mhc_vf_str      = eis_param_string('MHC vf                ', 'count', minp22, maxp22)
  asrc_str        = eis_param_string('ASRC stat             ', 'count', minp23, maxp23)
  mhc_load_str    = eis_param_string('MHC load stat         ', 'count', minp24, maxp24)
  hc_str          = eis_param_string('HC stat               ', 'count', minp25, maxp25)
  ee_stat1_str    = eis_param_string('Eeprom stat 1         ', 'count', minp26, maxp26)
  ee_stat2_str    = eis_param_string('Eeprom stat 2         ', 'count', minp27, maxp27)
  ee_cp_stat1_str = eis_param_string('Eeprom copy req stat  ', 'count', minp28, maxp28)
  ee_cp_stat2_str = eis_param_string('Eeprom copy prog stat ', 'count', minp29, maxp29)
  mhc_pwr_str     = eis_param_string('MHC power on stat     ', 'count', minp30, maxp30)
  
  if n_elements(lu) ne 0 then begin
     print, '	icu_status_parameters_check'
     printf, lu, title_str
     printf, lu, mode_str
     printf, lu, p2_str
     printf, lu, p3_str
     printf, lu, p4_str
     printf, lu, p5_str
     printf, lu, et_str
     printf, lu, cmd_buf_str
     printf, lu, xrt_ff_str
     printf, lu, eis_ff_str
     printf, lu, hm_mon_str
     printf, lu, aec_str
     printf, lu, mem_dmp_str
     printf, lu, seq_stat_str
     printf, lu, mode_en_str
     printf, lu, xrt_ff_rec_str
     printf, lu, xrt_ff_x_str
     printf, lu, xrt_ff_y_str
     printf, lu, md_buf_str
     printf, lu, icu_vf_str
     printf, lu, psu_vf_str
     printf, lu, cam_vf_str
     printf, lu, mhc_vf_str
     printf, lu, asrc_str
     printf, lu, mhc_load_str
     printf, lu, hc_str
     printf, lu, ee_stat1_str
     printf, lu, ee_stat2_str
     printf, lu, ee_cp_stat1_str
     printf, lu, ee_cp_stat2_str
     printf, lu, mhc_pwr_str
     printf, lu
  endif else begin
     print, title_str
     print, mode_str
     print, cmd_buf_str
     print, hm_mon_str
     print, seq_stat_str
     print, md_buf_str
     print, psu_vf_str
     print, cam_vf_str
     print, mhc_vf_str
     print
  endelse
end

pro icu_psu_status_parameters_check, files, lu
  
  tmp = eis_get_daily_data(files,'PSU_MARK',           1,  6, maxp1,  minp1, start_time, end_time)
  tmp = eis_get_daily_data(files,'PSU_CCDB_HTR_EN',    2,  6, maxp2,  minp2)
  tmp = eis_get_daily_data(files,'PSU_CCDA_HTR_EN',    3,  6, maxp3,  minp3)
  tmp = eis_get_daily_data(files,'PSU_CCDB_BHTR_STAT', 4,  6, maxp4,  minp4)
  tmp = eis_get_daily_data(files,'PSU_CCDA_BHTR_STAT', 5,  6, maxp5,  minp5)
  tmp = eis_get_daily_data(files,'PSU_MHC_HTR_P28V',   6,  6, maxp6,  minp6)
  tmp = eis_get_daily_data(files,'PSU_MHC_MECH_P28V',  7,  6, maxp7,  minp7)
  tmp = eis_get_daily_data(files,'PSU_MHC_ELEC_P28V',  8,  6, maxp8,  minp8)
  tmp = eis_get_daily_data(files,'PSU_MHC_MHTR',       9,  6, maxp9,  minp9)
  tmp = eis_get_daily_data(files,'PSU_CAM_MHTR',       10, 6, maxp10, minp10)
  tmp = eis_get_daily_data(files,'PSU_CAM_P39V',       11, 6, maxp11, minp11)
  tmp = eis_get_daily_data(files,'PSU_CAM_N8V',        12, 6, maxp12, minp12)
  tmp = eis_get_daily_data(files,'PSU_CAM_P7V',        13, 6, maxp13, minp13)
  tmp = eis_get_daily_data(files,'PSU_CAM_P8V',        14, 6, maxp14, minp14)
  tmp = eis_get_daily_data(files,'PSU_CAM_P13V',       15, 6, maxp15, minp15)
  
  title_str = 'ICU PSU status                  min            max'
  frmt = 'count'
  p0_str  = eis_param_string('PSU mark              ', frmt, minp1,  maxp1)
  p1_str  = eis_param_string('PSU ccdb htr ena      ', frmt, minp2,  maxp2)
  p2_str  = eis_param_string('PSU ccda htr ena      ', frmt, minp3,  maxp3)
  p3_str  = eis_param_string('PSU ccdb bhtr stat    ', frmt, minp4,  maxp4)
  p4_str  = eis_param_string('PSU ccda bhtr stat    ', frmt, minp5,  maxp5)
  p5_str  = eis_param_string('PSU MHC htr +28v      ', frmt, minp6,  maxp6)
  p6_str  = eis_param_string('PSU MHC mech +28v     ', frmt, minp7,  maxp7)
  p7_str  = eis_param_string('PSU MHC elec +28v     ', frmt, minp8,  maxp8)
  p8_str  = eis_param_string('PSU MHC mhtr          ', frmt, minp9,  maxp9)
  p9_str  = eis_param_string('PSU CAM mhtr          ', frmt, minp10, maxp10)
  p10_str = eis_param_string('PSU CAM +39v          ', frmt, minp11, maxp11)
  p11_str = eis_param_string('PSU CAM -8v           ', frmt, minp12, maxp12)
  p12_str = eis_param_string('PSU CAM +7v           ', frmt, minp13, maxp13)
  p13_str = eis_param_string('PSU CAM +8v           ', frmt, minp14, maxp14)
  p14_str = eis_param_string('PSU CAM +13v          ', frmt, minp15, maxp15)
  
  if n_elements(lu) ne 0 then begin
     print, '	icu_psu_status_parameters_check'
     printf, lu, title_str
     printf, lu, p0_str
     printf, lu, p1_str
     printf, lu, p2_str
     printf, lu, p3_str
     printf, lu, p4_str
     printf, lu, p5_str
     printf, lu, p6_str
     printf, lu, p7_str
     printf, lu, p8_str
     printf, lu, p9_str
     printf, lu, p10_str
     printf, lu, p11_str
     printf, lu, p12_str
     printf, lu, p13_str
     printf, lu, p14_str
     printf, lu
  endif
end

pro icu_hm_status_parameters_check, files, lu
  
  title_str = 'ICU HM status parameters        min            max'
  
  tmp = eis_get_daily_data(files,'HM_OOL_ALERT', 1,  7, maxp1, minp1, start_time, end_time)
  tmp = eis_get_daily_data(files,'HM_PSU_TO',    2,  7, maxp2, minp2)
  tmp = eis_get_daily_data(files,'HM_CAM_TO',    3,  7, maxp3, minp3)
  tmp = eis_get_daily_data(files,'HM_MHC_TO',    4,  7, maxp4, minp4)
  tmp = eis_get_daily_data(files,'HM_PSU_OOL',   5,  7, maxp5, minp5)
  tmp = eis_get_daily_data(files,'HM_CAM_OOL',   6,  7, maxp6, minp6)
  tmp = eis_get_daily_data(files,'HM_MHC_OOL',   7,  7, maxp7, minp7)
  tmp = eis_get_daily_data(files,'HM_PARM_ID',   8,  7, maxp8, minp8)
  
  p0_str = eis_param_string('HM Ool Alert          ', 'count', minp1, maxp1)
  p1_str = eis_param_string('HM PSU Timeout        ', 'count', minp2, maxp2)
  p2_str = eis_param_string('HM CAM Timeout        ', 'count', minp3, maxp3)
  p3_str = eis_param_string('HM MHC Timeout        ', 'count', minp4, maxp4)
  p4_str = eis_param_string('HM PSU Ool            ', 'count', minp5, maxp5)
  p5_str = eis_param_string('HM CAM Ool            ', 'count', minp6, maxp6)
  p6_str = eis_param_string('HM MHC Ool            ', 'count', minp7, maxp7)
  p7_str = eis_param_string('HM Param Id           ', 'count', minp8, maxp8)
  
  if n_elements(lu) ne 0 then begin
     print, '	icu_hm_status_parameters_check'
     printf, lu, title_str
     printf, lu, p0_str
     printf, lu, p1_str
     printf, lu, p2_str
     printf, lu, p3_str
     printf, lu, p4_str
     printf, lu, p5_str
     printf, lu, p6_str
     printf, lu, p7_str
     printf, lu
  endif
end

pro icu_interface_parameters_check, files, lu
  
  p0  = eis_get_daily_data(files,'CMD_IF_STAT1',   1, 8, maxp1,  minp1, start_time, end_time)
  p1  = eis_get_daily_data(files,'MD_IF_STAT1',    2, 8, maxp2,  minp2)
  p2  = eis_get_daily_data(files,'STAT_IF_STAT1',  3, 8, maxp3,  minp3)
  p3  = eis_get_daily_data(files,'WD_IF_STAT1',    4, 8, maxp4,  minp4)
  p4  = eis_get_daily_data(files,'CMD_IF_STAT2',   5, 8, maxp5,  minp5)
  p5  = eis_get_daily_data(files,'MD_IF_STAT2',    6, 8, maxp6,  minp6)
  p6  = eis_get_daily_data(files,'STAT_IF_STAT2',  7, 8, maxp7,  minp7)
  p7  = eis_get_daily_data(files,'WD_IF_STAT2',    8, 8, maxp8,  minp8)
  p8  = eis_get_daily_data(files,'MHC_422_STAT1',  9, 8, maxp9,  minp9)
  p9  = eis_get_daily_data(files,'ROE_IF_STAT1',  10, 8, maxp10, minp10)
  p10 = eis_get_daily_data(files,'ROE_IF_STAT2',  11, 8, maxp11, minp11)
  p11 = eis_get_daily_data(files,'HSL_IF_STAT1',  12, 8, maxp12, minp12)
  p12 = eis_get_daily_data(files,'HSL_IF_STAT2',  13, 8, maxp13, minp13)
  p13 = eis_get_daily_data(files,'MHC_422_STAT2', 14, 8, maxp14, minp14)
  
;    g0 = where(p11 eq '79CC'X, c0)
;    g1 = where(p11 eq '7DCC'X, c1)
;    g2 = where(p12 eq '79CC'X, c2)
;    g3 = where(p12 eq '7DCC'X, c3)
;
;;    if c0 ne 0 then p11[g0] = 0
;;    if c1 ne 0 then p11[g1] = 0
;;    if c2 ne 0 then p12[g2] = 0
;;    if c3 ne 0 then p12[g3] = 0
;;    b0 = where(p11 ne 0, c0)
;;    b1 = where(p12 ne 0, c1)
;
;    num_readings = n_elements(p11)
;    hsl1_bad = num_readings - (c0 + c1)
;    hsl2_bad = num_readings - (c2 + c3)
  
  interface_check, p11, '79CC'x, '7DCC'x, hsl1_bad
  interface_check, p12, '79CC'x, '7DCC'x, hsl2_bad
  hsl1_str = ' (bad ' + strtrim(string(hsl1_bad), 2) + ' times)'
  hsl2_str = ' (bad ' + strtrim(string(hsl2_bad), 2) + ' times)'
  
  title_str = 'ICU interfaces                  min            max'
  
  frmat = 'zcount'
  
  p0_str  = eis_param_string('Cmd I/f stat1         ', frmat, minp1,  maxp1)
  p4_str  = eis_param_string('Cmd I/f stat2         ', frmat, minp5,  maxp5)
  p1_str  = eis_param_string('Md  I/f stat1         ', frmat, minp2,  maxp2)
  p5_str  = eis_param_string('Md  I/f stat2         ', frmat, minp6,  maxp6)
  p2_str  = eis_param_string('St  I/f stat1         ', frmat, minp3,  maxp3)
  p6_str  = eis_param_string('St  I/f stat2         ', frmat, minp7,  maxp7)
  p3_str  = eis_param_string('Wd  I/f stat1         ', frmat, minp4,  maxp4)
  p7_str  = eis_param_string('Wd  I/f stat2         ', frmat, minp8,  maxp8)
  p8_str  = eis_param_string('MHC RS422 I/f stat1   ', frmat, minp9,  maxp9)
  p13_str = eis_param_string('MHC RS422 I/f stat2   ', frmat, minp14, maxp14)
  p9_str  = eis_param_string('ROE I/f stat1         ', frmat, minp10, maxp10)
  p10_str = eis_param_string('ROE I/f stat2         ', frmat, minp11, maxp11)
  p11_str = eis_param_string('HSL I/f stat1         ', frmat, minp12, maxp12)
  p12_str = eis_param_string('HSL I/f stat2         ', frmat, minp13, maxp13)
  
;    hsl1_str = 'Health monitor stat    : ', strtrim(string(format=('Z4'), minp12)
;    hsl1_str = 'HSL1 bad              : ' + strtrim(string(hsl1_bad), 2) + ' times'
;    hsl2_str = 'HSL2 bad              : ' + strtrim(string(hsl2_bad), 2) + ' times'
  
  if n_elements(lu) ne 0 then begin
     print, '	icu_interface_parameters_check'
     printf, lu, title_str
     printf, lu, p0_str
     printf, lu, p4_str
     printf, lu, p1_str
     printf, lu, p5_str
     printf, lu, p2_str
     printf, lu, p6_str
     printf, lu, p3_str
     printf, lu, p7_str
     printf, lu, p8_str
     printf, lu, p13_str
     printf, lu, p9_str
     printf, lu, p10_str
     printf, lu, p11_str + hsl1_str
     printf, lu, p12_str + hsl2_str
     printf, lu
  endif else begin
     print, title_str
;        print, hsl1_str
;        print, hsl2_str
     print
  endelse
end

pro icu_error_parameters_check, files, lu
  
  tmp = eis_get_daily_data(files,'TC_FAILED_EC',       1, 9, maxp1,  minp1, start_time, end_time)
  tmp = eis_get_daily_data(files,'CMD_IF_ERROR',       2, 9, maxp2,  minp2)
  tmp = eis_get_daily_data(files,'PSU_STAT_ERROR',     3, 9, maxp3,  minp3)
  tmp = eis_get_daily_data(files,'TC_FAILED_CMD_ID',   4, 9, maxp4,  minp4)
  tmp = eis_get_daily_data(files,'ICU_ERROR_F',        5, 9, maxp5,  minp5)
  tmp = eis_get_daily_data(files,'XRT_ERROR',          6, 9, maxp6,  minp6)
  tmp = eis_get_daily_data(files,'HC_DUTY_ERROR',      7, 9, maxp7,  minp7)
  tmp = eis_get_daily_data(files,'HC_PSU_TO',          8, 9, maxp8,  minp8)
  tmp = eis_get_daily_data(files,'MDP_LL_ERROR',       9, 9, maxp9,  minp9)
  tmp = eis_get_daily_data(files,'MHC_CMD_H',         10, 9, maxp10, minp10)
  tmp = eis_get_daily_data(files,'FT_ERROR',          11, 9, maxp11, minp11)
  tmp = eis_get_daily_data(files,'AEC_WIN_ERROR',     12, 9, maxp12, minp12)
  tmp = eis_get_daily_data(files,'AEC_PARMS_ERROR',   13, 9, maxp13, minp13)
  tmp = eis_get_daily_data(files,'AEC_TIME_ERROR',    14, 9, maxp14, minp14)
  tmp = eis_get_daily_data(files,'CAM_IF_ERROR',      15, 9, maxp15, minp15)
  tmp = eis_get_daily_data(files,'SEQ_ABORT_CODE',    16, 9, maxp16, minp16)
  tmp = eis_get_daily_data(files,'CMD_ID_FAILED_INT', 17, 9, maxp17, minp17)
  tmp = eis_get_daily_data(files,'MHC_IF_ERROR',      18, 9, maxp18, minp18)
  tmp = eis_get_daily_data(files,'EEPROM_ERROR',      19, 9, maxp19, minp19)
  tmp = eis_get_daily_data(files,'ET_ERROR',          20, 9, maxp20, minp20)
  tmp = eis_get_daily_data(files,'TC_FAILED_PKTC',    21, 9, maxp21, minp21)
  
  frmat = 'count'
  
  title_str = 'ICU errors                      min            max'
  
  icu_err_str   = eis_param_string('ICU error flag        ', frmat,  minp5,  maxp5)
  cmd_if_str    = eis_param_string('Cmd i/f error         ', frmat,  minp2,  maxp2)
  p3_str        = eis_param_string('PSU stat error        ', frmat,  minp3,  maxp3)
  mdp_ll_str    = eis_param_string('MDP ll error          ', frmat,  minp9,  maxp9)
  cam_if_str    = eis_param_string('CAM i/f error         ', frmat,  minp15, maxp15)
  tc_fail_str   = eis_param_string('Tc fail pktc          ', frmat,  minp21, maxp21)
  seq_abort_str = eis_param_string('Seq abort             ', frmat,  minp16, maxp16) + '	(1 = ground (MDP) abort, 2 = sequence xsum, 6,7 = linelist error, 8 = shutter abort)'
  p17_str       = eis_param_string('Cmd id int fail       ', frmat,  minp17, maxp17)
  p18_str       = eis_param_string('MHC i/f error         ', 'hex2', minp18, maxp18)
  tc_ec_str     = eis_param_string('Tc fail ec            ', frmat,  minp1,  maxp1)
  cmd_fail_str  = eis_param_string('Tc fail cmd           ', frmat,  minp4,  maxp4)
  
  p6_str        = eis_param_string('XRT error             ', frmat,  minp6,  maxp6)
  p7_str        = eis_param_string('HC duty error         ', frmat,  minp7,  maxp7)
  p8_str        = eis_param_string('HC PSU timeout        ', frmat,  minp8,  maxp8)
  p10_str       = eis_param_string('MHC cmd high word     ', frmat,  minp10, maxp10)
  p11_str       = eis_param_string('FT error              ', frmat,  minp11, maxp11)
  p12_str       = eis_param_string('AEC window error      ', frmat,  minp12, maxp12)
  p13_str       = eis_param_string('AEC parameter error   ', frmat,  minp13, maxp13)
  p14_str       = eis_param_string('AEC time error        ', frmat,  minp14, maxp14)
  p19_str       = eis_param_string('Eeprom error          ', frmat,  minp19, maxp19)
  p20_str       = eis_param_string('ET error              ', frmat,  minp20, maxp20)
  
  if n_elements(lu) ne 0 then begin
     print, '	icu_error_parameters_check'
     printf, lu, title_str
     printf, lu, icu_err_str
     printf, lu, cmd_if_str
     printf, lu, p3_str
     printf, lu, mdp_ll_str
     printf, lu, cam_if_str
     printf, lu, tc_fail_str
     printf, lu, seq_abort_str
     printf, lu, p17_str
     printf, lu, p18_str
     printf, lu, tc_ec_str
     printf, lu, cmd_fail_str
     printf, lu, p6_str
     printf, lu, p7_str
     printf, lu, p8_str
     printf, lu, p10_str
     printf, lu, p11_str
     printf, lu, p12_str
     printf, lu, p13_str
     printf, lu, p14_str
     printf, lu, p19_str
     printf, lu, p20_str
     printf, lu
    endif else begin
       print, title_str
       print, icu_err_str
       print, cmd_if_str
       print, p3_str
       print, mdp_ll_str
       print, cam_if_str
       print, tc_fail_str
       print, seq_abort_str
       print, tc_ec_str
       print, cmd_fail_str
       print
    endelse
 end

pro icu_counter_parameters_check, files, lu
  
  tmp = eis_get_daily_data(files,'MDP_TIME',       1,  10, maxp0, minp0, start_time, end_time)
  tmp = eis_get_daily_data(files,'STATUS_PC',      2,  10, maxp1, minp1)
  tmp = eis_get_daily_data(files,'TC_REC_PKTC',    3,  10, maxp2, minp2)
  tmp = eis_get_daily_data(files,'RASTER_RUN_REM', 4,  10, maxp3, minp3)
  tmp = eis_get_daily_data(files,'SEQ_RUN_REM',    5,  10, maxp4, minp4)
  tmp = eis_get_daily_data(files,'EXP_NUM',        6,  10, maxp5, minp5)
  
  frmat = 'count'
  
  title_str = 'ICU counters                    min            max'
  
  p2_str = eis_param_string('Status PC             ', frmat, minp1, maxp1)
  p3_str = eis_param_string('Tc received count     ', frmat, minp2, maxp2)
  p4_str = eis_param_string('Raster run remaining  ', frmat, minp3, maxp3)
  p5_str = eis_param_string('Seq    run remaining  ', frmat, minp4, maxp4)
  p6_str = eis_param_string('Exposures count       ', frmat, minp5, maxp5)
  
  if n_elements(lu) ne 0 then begin
     print, '	icu_counter_parameters_check'
     printf, lu, title_str
     printf, lu, p2_str
     printf, lu, p3_str
     printf, lu, p4_str
     printf, lu, p5_str
     printf, lu, p6_str
     printf, lu
  endif else begin
     print, title_str
     print
  endelse
  
end

pro icu_science_status_parameters_check, files, lu
  
  p0  = eis_get_daily_data(files,'SEQ_I', 1,  11, maxp0, minp0, start_time, end_time)
;    p1  = eis_get_daily_data(files,'SEQ_P', 2,  11, maxp1, minp1)
;    p2  = eis_get_daily_data(files,'LL_I',  3,  11, maxp2, minp2)
  
  n = n_elements(p0)
  s1=p0[0:n-2]-p0[1:n-1]
  foo=where(s1 ne 0)
  foo=[foo,n-1]
;
  title_str = 'ICU Science'
  seq_str = 'Sequences run          : '
  
  if n_elements(lu) ne 0 then begin
     print, '	icu_science_parameters_check'
     printf, lu, title_str
     printf, lu, seq_str, p0[foo]
     printf, lu
    endif else begin
       print, title_str
       print, seq_str, p0[foo]
       print
    endelse
 end

pro icu_spacecraft_check, files, output, end_time

  p0  = eis_get_daily_data(files,'TIME', 1,  12, maxp1, minp1, start_time, end_time)
  p1  = eis_get_daily_data(files,'SEQ_COUNTER', 2,  12, maxp2, minp2)
  
end

pro eis_status_sts1_check, dir, lu
  
  print, 'eis_status_sts1_check'

  files = findfile(dir + 'eis_sts1_*fits*', count=count)
  if count eq 0 then begin
;     print, 'eis_status_sts1_check'
     print, '	No files'
     return
  endif
  
  if n_elements(lu) ne 0 then begin
;     print, 'eis_status_sts1_check'
     icu_voltages_check,                  files, lu
     icu_currents_check,                  files, lu
     icu_temperatures_check,              files, lu
     icu_misc_parameters_check,           files, lu
     icu_status_parameters_check,         files, lu
     icu_psu_status_parameters_check,     files, lu
     icu_hm_status_parameters_check,      files, lu
     icu_interface_parameters_check,      files, lu
     icu_error_parameters_check,          files, lu
     icu_counter_parameters_check,        files, lu
     icu_science_status_parameters_check, files, lu
;;;    icu_spacecraft_check,                files, output, end_time
     return
  endif
  
  icu_voltages_check,        files
  icu_currents_check,        files
  icu_temperatures_check,    files
;    icu_misc_parameters_check, files
  icu_status_parameters_check,     files
;    icu_psu_status_parameters_check,     files, output, end_time
;    icu_hm_status_parameters_check,      files, output, end_time
  icu_interface_parameters_check,      files
  icu_error_parameters_check,          files
;    icu_counter_parameters_check,        files, output, end_time
  icu_science_status_parameters_check, files
;    icu_spacecraft_check,                files, output, end_time
  
end
