;+
; NAME: eis_status_sts2_conversions.pro
;
; PURPOSE: 
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	03/June/2006 v1.0 mcrw wrote
;       15/Nov/2006  v1.1 mcrw minor corrections
;       03/Dec/2006  v1.2 mcrw minor corrections
;
;-------------------------------------------------------------------------------------------------
pro hk2_parameters, files, output, end_time

    p0  = eis_get_daily_data(files,'TR_MODE',  1,  1, maxp1,  minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'UFSAUSE',  2,  1, maxp2,  minp2)
    p2  = eis_get_daily_data(files,'UFSBUSE',  3,  1, maxp3,  minp3)
    p3  = eis_get_daily_data(files,'SC_ATT_X', 4,  1, maxp4,  minp4)
    p4  = eis_get_daily_data(files,'SC_ATT_Y', 5,  1, maxp5,  minp5)
    p5  = eis_get_daily_data(files,'SC_ATT_Z', 6,  1, maxp6,  minp6)

;    minr = min([minp1, minp2, minp3, minp4, minp5])
;    maxr = max([maxp1, maxp2, maxp3, maxp4, maxp5])

;;;    x = lindgen(n_elements(p0))*5
    x = lindgen(n_elements(p0))*2

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/eis_hk2_parameters.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp1-1,maxp1+1], $
      title='TR_MODE',ytitle='Raw',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp2-1,maxp2+1], $
      title='UFSAUSE',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p2,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp3-1,maxp3+1], $
      title='UFSBUSE',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p3,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp4-1,maxp4+1], $
      title='SC_ATT_X',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p4,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp5-1,maxp5+1], $
      title='SC_ATT_Y',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p5,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp6-1,maxp6+1], $
      title='SC_ATT_Z',ytitle='Raw',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro hk2_spacecraft, files, output, end_time

    p0  = eis_get_daily_data(files,'TIME',        1,  2, maxp1, minp1, base_time, end_time)
    p1  = eis_get_daily_data(files,'SEQ_COUNTER', 2,  2, maxp2, minp2)

;;;    x = lindgen(n_elements(p0))*10
    x = lindgen(n_elements(p0))*2

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/hk2_spacecraft.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='TIME',ytitle='None',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='SEQ_COUNTER',ytitle='None',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro eis_status_hk2_conversions, dir, output, end_time

    files = findfile(dir + 'eis_hk2_*fits', count=count)
    if count eq 0 then begin
        print, 'eis_status_hk2_conversions : No files'
        return
    endif

    hk2_parameters, files, output, end_time
    hk2_spacecraft, files, output, end_time

end
