;+
; NAME: eis_status_sts2_conversions.pro
;
; PURPOSE: 
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	03/June/2006 v1.0 mcrw wrote
;       15/Nov/2006  v1.1 mcrw minor corrections
;       03/Dec/2006  v1.2 mcrw minor corrections
;
;-------------------------------------------------------------------------------------------------
pro cam_voltages_ql, files, output, end_time

    n_files = n_elements(files)
    for i = 0, n_files - 1 do begin
        p0   = eis_convert_cam_voltage_p5v1dig(eis_read_fits_data(files[i],'CAM_P5V1_DIG',  1)) ;;;;; , maxp1, minp1, base_time, end_time))
        p1   = eis_convert_cam_voltage_p2v5dig(eis_read_fits_data(files[i],'CAM_P2V5_DIG',  1))
        p2   = eis_convert_cam_voltage_p5vana (eis_read_fits_data(files[i],'CAM_P5V_AN_A',  1))
        p3   = eis_convert_cam_voltage_p5vanb (eis_read_fits_data(files[i],'CAM_P5V_AN_B',  1))
        p4   = eis_convert_cam_voltage_n5vana (eis_read_fits_data(files[i],'CAM_N5V_AN_A',  1))
        p5   = eis_convert_cam_voltage_n5vanb (eis_read_fits_data(files[i],'CAM_N5V_AN_B',  1))
        p6   = eis_convert_cam_voltage_p36va  (eis_read_fits_data(files[i],'CAM_P36V_A',    1))
        p7   = eis_convert_cam_voltage_p36vb  (eis_read_fits_data(files[i],'CAM_P36V_B',    1))
        p8   = eis_convert_cam_voltage_p12va  (eis_read_fits_data(files[i],'CAM_P12V_A',    1))
        p9   = eis_convert_cam_voltage_p12vb  (eis_read_fits_data(files[i],'CAM_P12V_B',    1))
        p10  = eis_convert_cam_voltage_n10va  (eis_read_fits_data(files[i],'CAM_N10V_A',    1))
        p11  = eis_convert_cam_voltage_n10vb  (eis_read_fits_data(files[i],'CAM_N10V_B',    1, header=header))

        base_time = fxpar(header, 'UT_START', count=count)
        end_time = fxpar(header, 'DATE_END')

;    minr = min([minp1, minp2, minp3, minp4, minp5])
;    maxr = max([maxp1, maxp2, maxp3, maxp4, maxp5])

        x = lindgen(n_elements(p0))*10

        cs=1.6

        set_plot,'ps'
        device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/cam_voltages' + strtrim(string(i),2) + '.ps'
        !p.multi=[0,1,3]

        utplot,x,p0,base_time,time_range=[base_time,end_time],xstyle=1,pstyle=4, $
          title='CAM +5V Digital Voltage',ytitle='Volts',charsize=cs

        utplot,x,p1,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +2.5V Digital Voltage',ytitle='Volts',charsize=cs,/ynozero

        utplot,x,p2,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +5V Analog A Voltage',ytitle='Volts',charsize=cs,/ynozero

        utplot,x,p3,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +5V Analog B Voltage',ytitle='Volts',charsize=cs,/ynozero

        utplot,x,p4,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM -5V Analog A Voltage',ytitle='Volts',charsize=cs,/ynozero

        utplot,x,p5,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM -5V Analog B Voltage',ytitle='Volts',charsize=cs,/ynozero

        utplot,x,p6,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +36V A Voltage',ytitle='Volts',charsize=cs,/ynozero

        utplot,x,p7,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +36V B Voltage',ytitle='Volts',charsize=cs,/ynozero

        utplot,x,p8,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +12V A Voltage',ytitle='Volts',charsize=cs,/ynozero

        utplot,x,p9,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +12V B Voltage',ytitle='Volts',charsize=cs,/ynozero

        utplot,x,p10,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM -10V A Voltage',ytitle='Volts',charsize=cs,/ynozero

        utplot,x,p11,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM -10V B Voltage',ytitle='Volts',charsize=cs,/ynozero

        device,/close
        set_plot,'X'
        !p.multi=0
    endfor
end

pro cam_currents_ql, files, output, end_time

    n_files = n_elements(files)
    for i = 0, n_files - 1 do begin
        p0  = eis_convert_cam_current_p5vdig  (eis_read_fits_data(files[i],'CAM_P5VI_DIG',  2)
        p1  = eis_convert_cam_current_p2p5vdig(eis_read_fits_data(files[i],'CAM_P2V5I_DIG', 2)
        p2  = eis_convert_cam_current_p5vana  (eis_read_fits_data(files[i],'CAM_P5VI_AN_A', 2)
        p3  = eis_convert_cam_current_p5vanb  (eis_read_fits_data(files[i],'CAM_P5VI_AN_B', 2)
        p4  = eis_convert_cam_current_n5vana  (eis_read_fits_data(files[i],'CAM_N5VI_AN_A', 2)
        p5  = eis_convert_cam_current_n5vanb  (eis_read_fits_data(files[i],'CAM_N5VI_AN_B', 2)
        p6  = eis_convert_cam_current_p36va   (eis_read_fits_data(files[i],'CAM_P36VI_A',   2)
        p7  = eis_convert_cam_current_p36vb   (eis_read_fits_data(files[i],'CAM_P36VI_B',   2)
        p8  = eis_convert_cam_current_p12va   (eis_read_fits_data(files[i],'CAM_P12VI_A',   2)
        p9  = eis_convert_cam_current_p12vb   (eis_read_fits_data(files[i],'CAM_P12VI_B',   2, header=header)

        base_time = fxpar(header, 'UT_START', count=count)
        end_time = fxpar(header, 'DATE_END')

;    minr = min([minp1, minp2, minp3, minp4, minp5])
;    maxr = max([maxp1, maxp2, maxp3, maxp4, maxp5])

        x = lindgen(n_elements(p0))*10

        cs=1.6

        set_plot,'ps'
        device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/cam_currents' + strtrim(string(i),2) + '.ps'
        !p.multi=[0,1,3]

        utplot,x,p0,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
;      yrange=[eis_convert_icu_current_p2p5v([minp1]),eis_convert_icu_current_p2p5v([maxp1])], $
        title='CAM +5V Digital Current',ytitle='Amps',charsize=cs

        utplot,x,p1,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +2.5V Digital Current',ytitle='Amps',charsize=cs,/ynozero

        utplot,x,p2,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +5V Analog A Current',ytitle='Amps',charsize=cs,/ynozero

        utplot,x,p3,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +5V Analog B Current',ytitle='Amps',charsize=cs,/ynozero

        utplot,x,p4,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM -5V Analog A Current',ytitle='Amps',charsize=cs,/ynozero

        utplot,x,p5,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM -5V Analog B Current',ytitle='Amps',charsize=cs,/ynozero

        utplot,x,p6,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +36V A Current',ytitle='Amps',charsize=cs,/ynozero

        utplot,x,p7,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +36V B Current',ytitle='Amps',charsize=cs,/ynozero

        utplot,x,p8,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +12V A Current',ytitle='Amps',charsize=cs,/ynozero

        utplot,x,p9,base_time,time_range=[base_time,end_time],xstyle=2,pstyle=4, $
          title='CAM +12V B Current',ytitle='Amps',charsize=cs,/ynozero

        device,/close
        set_plot,'X'
        !p.multi=0
    endfor
end

pro cam_ccd_biases_ql, files, output, end_time

    p0   = eis_convert_cam_bias_vod_a(eis_read_fits_data(files,'CAM_VOD_A',  1,  3, maxp1, minp1, base_time, end_time))
    p1   = eis_convert_cam_bias_vrd_a(eis_read_fits_data(files,'CAM_VRD_A',  2,  3, maxp2, minp2))
    p2   = eis_convert_cam_bias_vss_a(eis_read_fits_data(files,'CAM_VSS_A',  3,  3, maxp3, minp3))
    p3   = eis_convert_cam_bias_vod_b(eis_read_fits_data(files,'CAM_VOD_B',  4,  3, maxp4, minp4))
    p4   = eis_convert_cam_bias_vrd_b(eis_read_fits_data(files,'CAM_VRD_B',  5,  3, maxp5, minp5))
    p5   = eis_convert_cam_bias_vss_b(eis_read_fits_data(files,'CAM_VSS_B',  6,  3, maxp5, minp5))
    p6   = eis_convert_cam_bias_vod  (eis_read_fits_data(files,'CAM_VOD',    7,  3, maxp5, minp5))
    p7   = eis_convert_cam_bias_vrd  (eis_read_fits_data(files,'CAM_VRD',    8,  3, maxp5, minp5))
    p8   = eis_convert_cam_bias_vss  (eis_read_fits_data(files,'CAM_VSS',    9,  3, maxp5, minp5))

;    minr = min([minp1, minp2, minp3, minp4, minp5])
;    maxr = max([maxp1, maxp2, maxp3, maxp4, maxp5])

    x = lindgen(n_elements(p0))*10

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/cam_biases.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
;      yrange=[eis_convert_icu_current_p2p5v([minp1]),eis_convert_icu_current_p2p5v([maxp1])], $
      title='CAM VOD A',ytitle='Volts',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM VRD A',ytitle='Volts',charsize=cs,/ynozero

    utplot,x,p2,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM VSS A',ytitle='Volts',charsize=cs,/ynozero

    utplot,x,p3,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM VOD B',ytitle='Volts',charsize=cs,/ynozero

    utplot,x,p4,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM VRD B',ytitle='Volts',charsize=cs,/ynozero

    utplot,x,p5,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM VSS B',ytitle='Volts',charsize=cs,/ynozero

    utplot,x,p6,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM VOD',ytitle='Volts',charsize=cs,/ynozero

    utplot,x,p7,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM VRD',ytitle='Volts',charsize=cs,/ynozero

    utplot,x,p8,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM VSS',ytitle='Volts',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro cam_psu_voltages_ql, files, output, end_time

    p0   = eis_convert_cam_voltage_psup39v(eis_read_fits_data(files,'PSU_CAM_P39V',  1,  4, maxp1, minp1, base_time, end_time))
    p1   = eis_convert_cam_voltage_psup7v (eis_read_fits_data(files,'PSU_CAM_P7V',   2,  4, maxp2, minp2))
    p2   = eis_convert_cam_voltage_psun8v (eis_read_fits_data(files,'PSU_CAM_N8V',   3,  4, maxp3, minp3))
    p3   = eis_convert_cam_voltage_psup8v (eis_read_fits_data(files,'PSU_CAM_P8V',   4,  4, maxp4, minp4))
    p4   = eis_convert_cam_voltage_psup13v(eis_read_fits_data(files,'PSU_CAM_P13V',  5,  4, maxp5, minp5))

;    minr = min([minp1, minp2, minp3, minp4, minp5])
;    maxr = max([maxp1, maxp2, maxp3, maxp4, maxp5])

    x = lindgen(n_elements(p0))*10

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/cam_psu_voltages.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
;      yrange=[eis_convert_icu_current_p2p5v([minp1]),eis_convert_icu_current_p2p5v([maxp1])], $
      title='CAM PSU +39V',ytitle='Volts',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM PSU +7V',ytitle='Volts',charsize=cs,/ynozero

    utplot,x,p2,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM PSU -8V',ytitle='Volts',charsize=cs,/ynozero

    utplot,x,p3,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM PSU +8V',ytitle='Volts',charsize=cs,/ynozero

    utplot,x,p4,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM PSU +13V',ytitle='Volts',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro cam_psu_currents_ql, files, output, end_time

    p0   = eis_convert_cam_current_psup39v(eis_read_fits_data(files,'PSU_CAM_P39VI',  1,  5, maxp1, minp1, base_time, end_time))
    p1   = eis_convert_cam_current_psup7v (eis_read_fits_data(files,'PSU_CAM_P7VI',   2,  5, maxp2, minp2))
    p2   = eis_convert_cam_current_psun8v (eis_read_fits_data(files,'PSU_CAM_N8VI',   3,  5, maxp3, minp3))
    p3   = eis_convert_cam_current_psup8v (eis_read_fits_data(files,'PSU_CAM_P8VI',   4,  5, maxp4, minp4))
    p4   = eis_convert_cam_current_psup13v(eis_read_fits_data(files,'PSU_CAM_P13VI',  5,  5, maxp5, minp5))

;    minr = min([minp1, minp2, minp3, minp4, minp5])
;    maxr = max([maxp1, maxp2, maxp3, maxp4, maxp5])

    x = lindgen(n_elements(p0))*10

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/cam_psu_currents.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
;      yrange=[eis_convert_icu_current_p2p5v([minp1]),eis_convert_icu_current_p2p5v([maxp1])], $
      title='CAM PSU +39V Current',ytitle='Amps',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM PSU +7V Current',ytitle='Amps',charsize=cs,/ynozero

    utplot,x,p2,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM PSU -8V Current',ytitle='Amps',charsize=cs,/ynozero

    utplot,x,p3,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM PSU +8V Current',ytitle='Amps',charsize=cs,/ynozero

    utplot,x,p4,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM PSU +13V Current',ytitle='Amps',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro cam_icu_parameters_ql, files, output, end_time

    p0  = eis_read_fits_data(files,'CCD_BUF_ADD_F',   1,  6, maxp1,  minp1, base_time, end_time)
    p1  = eis_read_fits_data(files,'CCD_BUF_COUNT',   2,  6, maxp2,  minp2)
    p2  = eis_read_fits_data(files,'MHC_ALIVE_SYSEC', 3,  6, maxp3,  minp3)
    p3  = eis_read_fits_data(files,'EIS_XRT_X',       4,  6, maxp4,  minp4)
    p4  = eis_read_fits_data(files,'EIS_XRT_Y',       5,  6, maxp5,  minp5)
    p5  = eis_read_fits_data(files,'CMIR_POS_ARCS',   6,  6, maxp6,  minp6)
    p6  = eis_read_fits_data(files,'FMIR_OFFSET',     7,  6, maxp7,  minp7)
    p7  = eis_read_fits_data(files,'FMIR_SLOPE',      8,  6, maxp8,  minp8)
    p8  = eis_read_fits_data(files,'CMIR_SLOPE',      9,  6, maxp9,  minp9)
    p9  = eis_read_fits_data(files,'CMIR_RES_PX',    10,  6, maxp10, minp10)
    p10 = eis_read_fits_data(files,'CMIR_RES_NX',    11,  6, maxp11, minp11)
    p11 = eis_read_fits_data(files,'MHC_RESPONSE_TO',12,  6, maxp12, minp12)
    p12 = eis_read_fits_data(files,'FMIR_S_TIME',    13,  6, maxp13, minp13)
    p13 = eis_read_fits_data(files,'CMIR_SPAN_ARCS', 14,  6, maxp14, minp14)
    p14 = eis_read_fits_data(files,'EIS_XFOV',       15,  6, maxp15, minp15)
    p15 = eis_read_fits_data(files,'FT_XF',          16,  6, maxp16, minp16)
    p16 = eis_read_fits_data(files,'FT_YF',          17,  6, maxp17, minp17)
    p17 = eis_read_fits_data(files,'FT_XBIN_PEAK',   18,  6, maxp18, minp18)
    p18 = eis_read_fits_data(files,'FT_YBIN_PEAK',   19,  6, maxp19, minp19)
    p19 = eis_read_fits_data(files,'ET_XF',          20,  6, maxp20, minp20)
    p20 = eis_read_fits_data(files,'ET_YF',          21,  6, maxp21, minp21)
    p21 = eis_read_fits_data(files,'ET_XBIN_PEAK',   22,  6, maxp22, minp22)
    p22 = eis_read_fits_data(files,'ET_YBIN_PEAK',   23,  6, maxp23, minp23)

;    minr = min([minp1, minp2, minp3, minp4, minp5])
;    maxr = max([maxp1, maxp2, maxp3, maxp4, maxp5])

    x = lindgen(n_elements(p0))*10

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/cam_icu_parameters.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp1-1,maxp1+1], $
      title='CCD BUF ADD F',ytitle='Raw',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp2-1,maxp2+1], $
      title='CCD BUF COUNT',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p2,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp3-1,maxp3+1], $
      title='MHC ALIVE SYSEC',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p3,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp4-1,maxp4+1], $
      title='EIS XRT X',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p4,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp5-1,maxp5+1], $
      title='EIS XRT Y',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p5,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp6-1,maxp6+1], $
      title='CMIR POS ARCS',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p6,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp7-1,maxp7+1], $
      title='FMIR OFFSET',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p7,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp8-1,maxp8+1], $
      title='FMIR SLOPE',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p8,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp9-1,maxp9+1], $
      title='CMIR SLOPE',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p9,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp10-1,maxp10+1], $
      title='CMIR RES PX',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p10,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp11-1,maxp11+1], $
      title='CMIR RES NX',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p11,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp12-1,maxp12+1], $
      title='MHC RESPONSE TO',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p12,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp13-1,maxp13+1], $
      title='FMIR S TIME',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p13,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp14-1,maxp14+1], $
      title='CMIR SPAN ARCS',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p14,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp15-1,maxp15+1], $
      title='EIS XFOV',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p15,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp16-1,maxp16+1], $
      title='FT XF',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p16,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp17-1,maxp17+1], $
      title='FT YF',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p17,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp18-1,maxp18+1], $
      title='FT XBIN PEAK',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p18,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp19-1,maxp19+1], $
      title='FT YBIN PEAK',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p19,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp20-1,maxp20+1], $
      title='ET XF',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p20,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp21-1,maxp21+1], $
      title='ET YF',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p21,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp22-1,maxp22+1], $
      title='ET XBIN PEAK',ytitle='Pixels',charsize=cs,/ynozero

    utplot,x,p22,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      yrange=[minp23-1,maxp23+1], $
      title='ET YBIN PEAK',ytitle='Pixels',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro cam_misc_ql, files, output, end_time

    p0   = eis_read_fits_data(files,'CAM_CTL_REG1',     1,  7, maxp1, minp1, base_time, end_time)
    p1   = eis_read_fits_data(files,'CAM_CTL_REG2',     2,  7, maxp2, minp2)
    p2   = eis_read_fits_data(files,'CAM_SEU_COUNTER',  2,  7, maxp2, minp2)

;    minr = min([minp1, minp2, minp3, minp4, minp5])
;    maxr = max([maxp1, maxp2, maxp3, maxp4, maxp5])

    x = lindgen(n_elements(p0))*10

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/cam_misc.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
;      yrange=[eis_convert_icu_current_p2p5v([minp1]),eis_convert_icu_current_p2p5v([maxp1])], $
      title='CAM CTL REG1',ytitle='Raw',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM CTL REG2',ytitle='Raw',charsize=cs,/ynozero

    utplot,x,p2,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM SEU COUNTER',ytitle='Raw',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro cam_temperatures_ql, files, output, end_time

    p0   = eis_convert_cam_up_temperature(eis_read_fits_data(files,'CAM_UP_TEMP',  1,  8, maxp1, minp1, base_time, end_time))
    p1   = eis_convert_cam_lo_temperature(eis_read_fits_data(files,'CAM_LO_TEMP',  2,  8, maxp2, minp2))

;    minr = min([minp1, minp2, minp3, minp4, minp5])
;    maxr = max([maxp1, maxp2, maxp3, maxp4, maxp5])

    x = lindgen(n_elements(p0))*10

    cs=1.6

    set_plot,'ps'

    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/cam_temperatures.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
;      yrange=[eis_convert_icu_current_p2p5v([minp1]),eis_convert_icu_current_p2p5v([maxp1])], $
      title='CAM UP TEMP',ytitle='Degrees C',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='CAM LO TEMP',ytitle='Degrees C',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro cam_spacecraft_ql, files, output, end_time

    p0  = eis_read_fits_data(files,'TIME', 1,  9, maxp1, minp1, base_time, end_time)
    p1  = eis_read_fits_data(files,'SEQ_COUNTER', 2,  9, maxp2, minp2)

    x = lindgen(n_elements(p0))*10

    cs=1.6

    set_plot,'ps'
    device,xoff=2.5,yoff=6,xs=16,ys=18,file=output+'/icu_spacecraft.ps'
    !p.multi=[0,1,3]

    utplot,x,p0,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
;      yrange=[eis_convert_icu_current_p2p5v([minp1]),eis_convert_icu_current_p2p5v([maxp1])], $
      title='TIME',ytitle='None',charsize=cs

    utplot,x,p1,base_time,timerange=[base_time,end_time],xstyle=2,pstyle=4, $
      title='SEQ_COUNTER',ytitle='None',charsize=cs,/ynozero

    device,/close
    set_plot,'X'
    !p.multi=0
        
end

pro eis_status_sts2_conversions_ql, dir, output, end_time

    files = findfile(dir + 'eis_sts2_*fits', count=count)
    if count eq 0 then begin
        print, 'No files'
        return
    endif

    cam_voltages_ql,       files, output, end_time
;    cam_currents_ql,       files, output, end_time
;    cam_ccd_biases_ql,     files, output, end_time
;    cam_psu_voltages_ql,   files, output, end_time
;    cam_psu_currents_ql,   files, output, end_time
;    cam_icu_parameters_ql, files, output, end_time
;    cam_misc_ql,           files, output, end_time
;    cam_temperatures_ql,   files, output, end_time
;    cam_spacecraft_ql  ,   files, output, end_time
end
