pro eis_cam_temp_header, lu
    printf, lu, 'start_date,end_date,cup_min,cup_max,cup_avg,clo_min,clo_max,clo_avg'
end

;
; dir		(string)	['$HOME/data/status/2007/04/']
; log_file	(string)	['$HOME/work/localdata/log/status/trends/eis_ccd_temp_trend_200704.txt']
; hdr		(unused)
; scree_output	(unsued)
;
pro eis_cam_temp_trend, dir, log=log_file, hdr=hdr, screen_output=screen_output
    dirs = findfile(dir, count=count)
    if count eq 0 then begin
        print, 'No directories'
        return
    endif
    using_log = 0
    if n_elements(log_file) ne 0 then begin
        openw, lu, log_file, /append, /get_lun
        using_log = 1
    endif
    dir_base = dir
    if keyword_set(hdr) then begin
        if using_log then eis_cam_temp_header, lu
    endif
    for d = 0, count-1 do begin
        search_dir = dir_base+'/'+dirs[d]+'/'
        res = strpos(search_dir, 'trends')
        if res ne -1 then goto, skip
        files = findfile(search_dir + 'eis_sts2_*fits*', count=count)
        if count eq 0 then begin
            print, 'No data'
            if using_log then eis_no_data_string, lu, 2
        endif else begin

            p1 = reform(eis_get_daily_data(files,'CAM_UP_TEMP',1,8,maxp1,minp1,stim,etim))
            p2 = reform(eis_get_daily_data(files,'CAM_LO_TEMP',2,8,maxp2,minp2))

            cup_min = eis_convert_cam_up_temperature([maxp1])
            cup_max = eis_convert_cam_up_temperature([minp1])
            clo_min = eis_convert_cam_lo_temperature([maxp2])
            clo_max = eis_convert_cam_lo_temperature([minp2])

            mom = moment(p1)
            cup_avg = eis_convert_cam_up_temperature([mom[0]])
            cup_std = sqrt(mom[1])
            cup_skew = mom[2]
            cup_kurt = mom[3]
            mom = moment(p2)
            clo_avg = eis_convert_cam_lo_temperature([mom[0]])
            clo_std = sqrt(mom[1])
            clo_skew = mom[2]
            clo_kurt = mom[3]

            print,format='(2(A23," "),6(F8.2))', $
              stim,etim,cup_min,cup_max,cup_avg,clo_min,clo_max,clo_avg

            if using_log then begin
                printf,lu,format='(2(A23,","),5(F8.2,","),F8.2)', $
                  stim,etim,cup_min,cup_max,cup_avg,clo_min,clo_max,clo_avg
            endif
        endelse
skip:
    endfor

    if using_log then begin
        close, lu
        free_lun, lu
    endif

end

