pro eis_icu_psu_pwr_header, lu
    printf, lu, 'start_date,end_date,p2v5_min,p2v5_max,p2v5_avg,p5v_min,p5v_max,p5v_avg,p15v_min,p15v_max,p15v_avg,n15v_min,n15v_max,n15v_avg,p2v5i_min,p2v5i_max,p2v5i_avg,p5vi_min,p5vi_max,p5vi_avg,p15vi_min,p15vi_max,p15vi_avg,n15vi_min,n15vi_max,n15vi_avg,p2v5pwr_min,p2v5pwr_max,p2v5pwr_avg,p5vpwr_min,p5vpwr_max,p5vpwr_avg,p15vpwr_min,p15vpwr_max,p15vpwr_avg,n15vpwr_min,n15vpwr_max,n15vpwr_avg'
end

pro eis_icu_psu_pwr_trend, dir, log=log_file, hdr=hdr
    dirs = findfile(dir, count=count)
    if count eq 0 then begin
        print, 'No directories'
        return
    endif
    using_log = 0
    if n_elements(log_file) ne 0 then begin
        openw, lu, log_file, /append, /get_lun
        using_log = 1
    endif
    dir_base = dir
    if keyword_set(hdr) then begin
        if using_log then eis_icu_psu_pwr_header, lu
    endif
    for d = 0, count-1 do begin
        search_dir = dir_base+'/'+dirs[d]+'/'
        res = strpos(search_dir, 'trends')
        if res ne -1 then goto, skip
        files = findfile(search_dir + 'eis_sts1_*fits*', count=count)
        if count eq 0 then begin
            print, 'No data'
            if using_log then eis_no_data_string,lu,12
        endif else begin

            p0 = eis_convert_icu_voltage_p2p5v(eis_get_daily_data(files, 'ICU_P2V5', 1, 1, mx0, mn0, stime, etime))
            p1 = eis_convert_icu_voltage_p5v  (eis_get_daily_data(files, 'ICU_P5V',  2, 1, mx1, mn1))
            p2 = eis_convert_icu_voltage_p15v (eis_get_daily_data(files, 'ICU_P15V', 3, 1, mx2, mn2))
            p3 = eis_convert_icu_voltage_n15v (eis_get_daily_data(files, 'ICU_N15V', 4, 1, mx3, mn3))

            p4 = eis_convert_icu_current_p2p5v(eis_get_daily_data(files, 'ICU_P2I5', 1, 2, mx4, mn4))
            p5 = eis_convert_icu_current_p5v  (eis_get_daily_data(files, 'ICU_P5I',  2, 2, mx5, mn5))
            p6 = eis_convert_icu_current_p15v (eis_get_daily_data(files, 'ICU_P15I', 3, 2, mx6, mn6))
            p7 = eis_convert_icu_current_n15v (eis_get_daily_data(files, 'ICU_N15I', 4, 2, mx7, mn7))

            p0_min = eis_convert_icu_voltage_p2p5v([mn0])
            p1_min = eis_convert_icu_voltage_p5v  ([mn1])
            p2_min = eis_convert_icu_voltage_p15v ([mn2])
            p3_min = eis_convert_icu_voltage_n15v ([mn3])

            p0_max = eis_convert_icu_voltage_p2p5v([mx0])
            p1_max = eis_convert_icu_voltage_p5v  ([mx1])
            p2_max = eis_convert_icu_voltage_p15v ([mx2])
            p3_max = eis_convert_icu_voltage_n15v ([mx3])

            p4_min = eis_convert_icu_current_p2p5v([mn4])
            p5_min = eis_convert_icu_current_p5v  ([mn5])
            p6_min = eis_convert_icu_current_p15v ([mn6])
            p7_min = eis_convert_icu_current_n15v ([mn7])

            p4_max = eis_convert_icu_current_p2p5v([mx4])
            p5_max = eis_convert_icu_current_p5v  ([mx5])
            p6_max = eis_convert_icu_current_p15v ([mx6])
            p7_max = eis_convert_icu_current_n15v ([mx7])

;            p0_avg = eis_convert_icu_voltage_p2p5v([(moment(p0))[0]])
;            p1_avg = eis_convert_icu_voltage_p5v  ([(moment(p1))[0]])
;            p2_avg = eis_convert_icu_voltage_p15v ([(moment(p2))[0]])
;            p3_avg = eis_convert_icu_voltage_n15v ([(moment(p3))[0]])
;
;            p4_avg = eis_convert_icu_current_p2p5v([(moment(p4))[0]])
;            p5_avg = eis_convert_icu_current_p5v  ([(moment(p5))[0]])
;            p6_avg = eis_convert_icu_current_p15v ([(moment(p6))[0]])
;            p7_avg = eis_convert_icu_current_n15v ([(moment(p7))[0]])

            p0_avg = (moment(p0))[0]
            p1_avg = (moment(p1))[0]
            p2_avg = (moment(p2))[0]
            p3_avg = (moment(p3))[0]

            p4_avg = (moment(p4))[0]
            p5_avg = (moment(p5))[0]
            p6_avg = (moment(p6))[0]
            p7_avg = (moment(p7))[0]

            pwr = abs(p0 * p4)
            p0_pwr_min = min(pwr)
            p0_pwr_max = max(pwr)
            p0_pwr_avg = (moment(pwr))[0]
            pwr = abs(p1 * p5)
            p1_pwr_min = min(pwr)
            p1_pwr_max = max(pwr)
            p1_pwr_avg = (moment(pwr))[0]
            pwr = abs(p2 * p6)
            p2_pwr_min = min(pwr)
            p2_pwr_max = max(pwr)
            p2_pwr_avg = (moment(pwr))[0]
            pwr = abs(p3 * p7)
            p3_pwr_min = min(pwr)
            p3_pwr_max = max(pwr)
            p3_pwr_avg = (moment(pwr))[0]

            print,format='(2(A23,","),35(F8.2,","),F8.2)', $
              stime,etime,p0_min,p0_max,p0_avg,p1_min,p1_max,p1_avg,p2_min,p2_max,p2_avg,p3_min,p3_max,p3_avg,$
              p4_min,p4_max,p4_avg,p5_min,p5_max,p5_avg,p6_min,p6_max,p6_avg,p7_min,p7_max,p7_avg,$
              p0_pwr_min,p0_pwr_max,p0_pwr_avg,p1_pwr_min,p1_pwr_max,p1_pwr_avg,p2_pwr_min,p2_pwr_max,p2_pwr_avg,$
              p3_pwr_min,p3_pwr_max,p3_pwr_avg

            if using_log then begin
                 printf,lu,format='(2(A23,","),35(F8.2,","),F8.2)', $
                  stime,etime,p0_min,p0_max,p0_avg,p1_min,p1_max,p1_avg,p2_min,p2_max,p2_avg,p3_min,p3_max,p3_avg,$
                   p4_min,p4_max,p4_avg,p5_min,p5_max,p5_avg,p6_min,p6_max,p6_avg,p7_min,p7_max,p7_avg,$
                   p0_pwr_min,p0_pwr_max,p0_pwr_avg,p1_pwr_min,p1_pwr_max,p1_pwr_avg,p2_pwr_min,p2_pwr_max,p2_pwr_avg,$
                   p3_pwr_min,p3_pwr_max,p3_pwr_avg
            endif
        endelse
skip:
    endfor
    if using_log then begin
        close, lu
        free_lun, lu
    endif
end

