;+
; NAME: eis_status_sts3_conversions.pro
;
; PURPOSE: 
;      
; CATEGORY:
;
; CALLING SEQUENCE: 
;
; INPUTS: 
;
; KEYWORD PARAMETERS: None
;
; OUTPUTS: 
;
; CALLS:
;
; COMMON BLOCKS: None
;
; PROCEDURE:
;
; RESTRICTIONS: Uses SolarSoft
;
; MODIFICATION HISTORY:
;	03/June/2006	mcrw wrote
;       21/Sept/2006    mcrw v2.0
;
;-------------------------------------------------------------------------------------------------

; .comp ../../archive_check/eis_count_check
; .comp ../../fxbopen
; .comp eis_mhc_mech_moves

;pro eis_mhc_mech_moves, dir, log=log_file
pro eis_mhc_mech_moves, dir, log=log_file
    dirs = findfile(dir, count=count)
    if count eq 0 then begin
        print, 'No directories'
        return
    endif
    using_log = 0
    monthly_total = 0L
    if n_elements(log_file) ne 0 then begin
        openw, lu, log_file, /append, /get_lun
        using_log = 1
    endif
    dir_base = dir
    for d = 0, count-1 do begin
        daily_total = 0L
        dir = dir_base+'/'+dirs[d]+'/'
        res = strpos(dir, 'trends')
        if res ne -1 then goto, skip
        files = findfile(dir + 'eis_sts3_*fits*', count=count)
        if count eq 0 then begin
            print, 'No data'
            if using_log then printf, lu, 'No data'
        endif else begin
            for f = 0, count - 1 do begin
                filename_parts = str_sep(files[f],'/')
                basename = filename_parts[n_elements(filename_parts) -1]
                eis_get_status_data,files[f], p1, 'MHC_SS_POS_STEPS',   6, mx1, mn1
                foo = where(eis_count_check(p1) ne 0, move_count)
                daily_total = daily_total + move_count
;            print, files[f], where(eis_count_check(p1) ne 0)
                print, files[f], move_count
 ;               if using_log then printf, lu, files[f], move_count
                if using_log then printf, lu, basename, move_count
            endfor
            print, 'Daily total ',daily_total
            if using_log then begin
                printf, lu, 'Daily total ',daily_total
                printf, lu
            endif
        endelse
        monthly_total = monthly_total + daily_total
skip:
    endfor
    print, 'Monthly total ', monthly_total
    if using_log then begin
        printf, lu, 'Monthly total ', monthly_total
        close, lu
        free_lun, lu
    endif
end
