pro eis_plot_icu_psu_pwr_trend, filename, ptit, output=output

    ; Restore 'template'
    restore, '$HOME/work/idl/templates/eis_icu_psu_template.sav'
    d = read_ascii(filename, template=template)

    ytit='Volts'
    eis_plot_trend_data, '+2.5 VOLTS',        ptit, output+'_voltage',    d.p2v5_min,      d.p2v5_max,      d.p2v5_avg,      ytit, /start
    eis_plot_trend_data, '+5 VOLTS',          ptit, output+'',     d.p5v_min,       d.p5v_max,       d.p5v_avg,       ytit
    eis_plot_trend_data, '+15 VOLTS',         ptit, output+'',    d.p15v_min,      d.p15v_max,      d.p15v_avg,      ytit
    eis_plot_trend_data, '-15 VOLTS',         ptit, output+'',    d.n15v_min,      d.n15v_max,      d.n15v_avg,      ytit, /finish

    ytit='Amps'
    eis_plot_trend_data, '+2.5 VOLT CURRENT', ptit, output+'_currents',   d.p2v5i_min,     d.p2v5i_max,     d.p2v5i_avg,     ytit, /start
    eis_plot_trend_data, '+5 VOLT CURRENT',   ptit, output+'',    d.p5vi_min,      d.p5vi_max,      d.p5vi_avg,      ytit
    eis_plot_trend_data, '+15 VOLT CURRENT',  ptit, output+'',   d.p15vi_min,     d.p15vi_max,     d.p15_vi_avg,     ytit
    eis_plot_trend_data, '-15 VOLT CURRENT',  ptit, output+'',   d.n15vi_min,     d.n15vi_max,     d.n15vi_avg,     ytit, /finish

    ytit='Watts'
    eis_plot_trend_data, '+2.5 VOLT POWER',   ptit, output+'_power', d.p2v5pwr_min, d.p2v5pwr_max, d.p2v5pwr_avg, ytit, /start
    eis_plot_trend_data, '+5 VOLT POWER',     ptit, output+'',  d.p5vpwr_min,   d.p5vpwr_max,   d.p5vpwr_avg,   ytit
    eis_plot_trend_data, '+15 VOLT POWER',    ptit, output+'', d.p15vpwr_min,  d.p15vpwr_max,  d.p15vpwr_avg,  ytit
    eis_plot_trend_data, '-15 VOLT POWER',    ptit, output+'', d.n15vpwr_min,  d.n15vpwr_max,  d.n15vpwr_avg,  ytit, /finish

end
