pro eis_plot_mbus_pwr_trend, filename, ptit, output=output

    ; Restore 'template'
    restore, '$HOME/work/idl/templates/eis_mbus_pwr_template.sav'
    d = read_ascii(filename, template=template)

    eis_plot_trend_data, 'MBUS_VOLTAGE',     ptit, output+'', d.p28v_min,  d.p28v_max,  d.p28v_avg, 'Voltage', /start
    eis_plot_trend_data, 'MBUS_CURRENT',     ptit, output+'', d.p28vi_min, d.p28vi_max, d.p28vi_avg, 'Amps'
    eis_plot_trend_data, 'MBUS_POWER',       ptit, output+'', d.p28v_pwr_min, d.p28v_pwr_max, d.p28v_pwr_avg, 'Watts'

    eis_plot_trend_data, 'MBUS_VOLTAGE_STD', ptit, output+'', d.p28v_std,  d.p28v_skew, d.p28v_kurt, '', /std
    eis_plot_trend_data, 'MBUS_CURRENT_STD', ptit, output+'', d.p28vi_std,  d.p28vi_skew, d.p28vi_kurt, '', /std
    eis_plot_trend_data, 'MBUS_POWER_STD',   ptit, output+'', d.p28v_pwr_std,  d.p28v_pwr_skew, d.p28v_pwr_kurt, '', /std, /finish

end
