; filename		(string)	['$HOME/work/localdata/log/status/trends/eis_ccd_temp_trend_200704.txt']
; ptit (plot title)	(string)	['April 2007']
; output		(string)	['$HOME/work/localdata/log/status/trends/ccd_temp_200704']
pro eis_plot_str_temp_trend, filename, ptit, output=output

    ; Restore 'template'
    restore, '$HOME/work/idl/templates/eis_str_temp_template.sav'
    d = read_ascii(filename, template=template)

    ytit='Degrees C'

    eis_plot_trend_data, 'HTR_A', ptit, output+'', d.htra_min, d.htra_max, d.htra_avg, ytit, /start
    eis_plot_trend_data, 'HTR_B', ptit, output+'', d.htrb_min, d.htrb_max, d.htrb_avg, ytit
    eis_plot_trend_data, 'HTR_C', ptit, output+'', d.htrc_min, d.htrc_max, d.htrc_avg, ytit
    eis_plot_trend_data, 'ICU_1', ptit, output+'', d.icu1_min, d.icu1_max, d.icu1_avg, ytit
    eis_plot_trend_data, 'ICU_2', ptit, output+'', d.icu2_min, d.icu2_max, d.icu2_avg, ytit
    eis_plot_trend_data, 'STR_1', ptit, output+'', d.str1_min, d.str1_max, d.str1_avg, ytit
    eis_plot_trend_data, 'STR_2', ptit, output+'', d.str2_min, d.str2_max, d.str2_avg, ytit
    eis_plot_trend_data, 'STR_3', ptit, output+'', d.str3_min, d.str3_max, d.str3_avg, ytit
    eis_plot_trend_data, 'STR_4', ptit, output+'', d.str4_min, d.str4_max, d.str4_avg, ytit
    eis_plot_trend_data, 'STR_5', ptit, output+'', d.str5_min, d.str5_max, d.str5_avg, ytit
    eis_plot_trend_data, 'STR_6', ptit, output+'', d.str6_min, d.str6_max, d.str6_avg, ytit
    eis_plot_trend_data, 'STR_7', ptit, output+'', d.str7_min, d.str7_max, d.str7_avg, ytit, /finish
                                                                                                  
end
